/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.client.helpers.domain.impl;

import java.io.Serializable;
import java.util.UUID;
import org.shaded.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.shaded.jboss.as.controller.client.helpers.domain.ServerUpdateResult;
import org.shaded.jboss.as.controller.client.helpers.domain.impl.UpdateResultHandlerResponse;
import org.shaded.jboss.as.controller.client.logging.ControllerClientLogger;
import org.shaded.jboss.dmr.ModelNode;

class ServerUpdateResultImpl
implements ServerUpdateResult,
Serializable {
    private static final long serialVersionUID = 5879115765933810032L;
    private final UUID actionId;
    private final ServerIdentity serverId;
    private final UpdateResultHandlerResponse urhr;
    private UpdateResultHandlerResponse rollbackResult;

    ServerUpdateResultImpl(UUID actionId, ServerIdentity serverId, UpdateResultHandlerResponse urhr) {
        assert (actionId != null) : "actionId is null";
        assert (serverId != null) : "serverId is null";
        assert (urhr != null) : "urhr is null";
        this.actionId = actionId;
        this.serverId = serverId;
        this.urhr = urhr;
    }

    @Override
    public Throwable getFailureResult() {
        return this.urhr.getFailureResult();
    }

    @Override
    public ServerIdentity getServerIdentity() {
        return this.serverId;
    }

    @Override
    public ModelNode getSuccessResult() {
        return this.urhr.getSuccessResult();
    }

    @Override
    public UUID getUpdateActionId() {
        return this.actionId;
    }

    @Override
    public boolean isCancelled() {
        return this.urhr.isCancelled();
    }

    @Override
    public boolean isRolledBack() {
        return this.rollbackResult != null || this.urhr.isRolledBack();
    }

    @Override
    public boolean isTimedOut() {
        return this.urhr.isTimedOut();
    }

    void markRolledBack(UpdateResultHandlerResponse rollbackResult) {
        this.rollbackResult = rollbackResult;
    }

    @Override
    public boolean isServerRestarted() {
        return this.urhr.isServerRestarted();
    }

    @Override
    public Throwable getRollbackFailure() {
        if (this.rollbackResult == null) {
            return null;
        }
        if (this.rollbackResult.isCancelled()) {
            return ControllerClientLogger.ROOT_LOGGER.rollbackCancelled();
        }
        if (this.rollbackResult.isRolledBack()) {
            return ControllerClientLogger.ROOT_LOGGER.rollbackRolledBack();
        }
        if (this.rollbackResult.isTimedOut()) {
            return ControllerClientLogger.ROOT_LOGGER.rollbackTimedOut();
        }
        return this.rollbackResult.getFailureResult();
    }
}

