/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.client.helpers.domain.impl;

import java.io.Serializable;
import org.shaded.jboss.as.controller.client.helpers.domain.UpdateFailedException;
import org.shaded.jboss.as.controller.client.logging.ControllerClientLogger;
import org.shaded.jboss.dmr.ModelNode;

public class UpdateResultHandlerResponse
implements Serializable {
    private static final long serialVersionUID = -5250735019112151634L;
    private final ModelNode successResult;
    private final Throwable failureResult;
    private final boolean cancelled;
    private final boolean timedOut;
    private final boolean rolledBack;
    private final boolean restarted;
    private final boolean rollbackCancelled;
    private final boolean rollbackTimedOut;
    private final Throwable rollbackFailure;

    public static UpdateResultHandlerResponse fromModelNode(ModelNode modelNode) {
        String message;
        UpdateResultHandlerResponse result;
        String outcome;
        String string = outcome = modelNode.hasDefined("outcome") ? modelNode.get("outcome").asString() : ControllerClientLogger.ROOT_LOGGER.failed();
        if ("success".equals(outcome)) {
            result = UpdateResultHandlerResponse.createSuccessResponse(modelNode.get("result"));
        } else {
            if ("cancelled".equals(outcome)) {
                return UpdateResultHandlerResponse.createCancellationResponse();
            }
            message = modelNode.hasDefined("failure-description") ? modelNode.get("failure-description").toString() : ControllerClientLogger.ROOT_LOGGER.noFailureDetails();
            result = UpdateResultHandlerResponse.createFailureResponse(new UpdateFailedException(message));
        }
        if (modelNode.get("rolled-back").asBoolean(false)) {
            result = UpdateResultHandlerResponse.createRollbackResponse(result);
        } else if (modelNode.hasDefined("rollback-failure-description")) {
            message = modelNode.get("rollback-failure-description").toString();
            result = UpdateResultHandlerResponse.createRollbackFailedResponse(result, new UpdateFailedException(message));
        }
        return result;
    }

    public static UpdateResultHandlerResponse createSuccessResponse(ModelNode result) {
        return new UpdateResultHandlerResponse(result, null, false, false, false, false, false, false, null);
    }

    public static UpdateResultHandlerResponse createFailureResponse(Throwable cause) {
        return new UpdateResultHandlerResponse(null, cause, false, false, false, false, false, false, null);
    }

    public static UpdateResultHandlerResponse createCancellationResponse() {
        return new UpdateResultHandlerResponse(null, null, true, false, false, false, false, false, null);
    }

    public static UpdateResultHandlerResponse createTimeoutResponse() {
        return new UpdateResultHandlerResponse(null, null, false, true, false, false, false, false, null);
    }

    public static UpdateResultHandlerResponse createRollbackResponse(UpdateResultHandlerResponse rolledBack) {
        return new UpdateResultHandlerResponse(rolledBack.successResult, rolledBack.failureResult, rolledBack.cancelled, rolledBack.timedOut, rolledBack.restarted, true, false, false, null);
    }

    public static UpdateResultHandlerResponse createRollbackCancelledResponse(UpdateResultHandlerResponse rolledBack) {
        return new UpdateResultHandlerResponse(rolledBack.successResult, rolledBack.failureResult, rolledBack.cancelled, rolledBack.timedOut, rolledBack.restarted, false, true, false, null);
    }

    public static UpdateResultHandlerResponse createRollbackTimedOutResponse(UpdateResultHandlerResponse rolledBack) {
        return new UpdateResultHandlerResponse(rolledBack.successResult, rolledBack.failureResult, rolledBack.cancelled, rolledBack.timedOut, rolledBack.restarted, false, false, true, null);
    }

    public static UpdateResultHandlerResponse createRollbackFailedResponse(UpdateResultHandlerResponse rolledBack, Throwable cause) {
        return new UpdateResultHandlerResponse(rolledBack.successResult, rolledBack.failureResult, rolledBack.cancelled, rolledBack.timedOut, rolledBack.restarted, false, false, false, cause);
    }

    public static UpdateResultHandlerResponse createRestartResponse() {
        return new UpdateResultHandlerResponse(null, null, false, false, true, false, false, false, null);
    }

    private UpdateResultHandlerResponse(ModelNode successResult, Throwable failureResult, boolean cancelled, boolean timedOut, boolean restarted, boolean rolledBack, boolean rollbackCancelled, boolean rollbackTimedOut, Throwable rollbackFailure) {
        this.successResult = successResult;
        this.failureResult = failureResult;
        this.cancelled = cancelled;
        this.timedOut = timedOut;
        this.restarted = restarted;
        this.rolledBack = rolledBack;
        this.rollbackCancelled = rollbackCancelled;
        this.rollbackTimedOut = rollbackTimedOut;
        this.rollbackFailure = rollbackFailure;
    }

    public boolean isRollbackCancelled() {
        return this.rollbackCancelled;
    }

    public boolean isRollbackTimedOut() {
        return this.rollbackTimedOut;
    }

    public Throwable getRollbackFailure() {
        return this.rollbackFailure;
    }

    public ModelNode getSuccessResult() {
        return this.successResult;
    }

    public Throwable getFailureResult() {
        return this.failureResult;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public boolean isRolledBack() {
        return this.rolledBack;
    }

    public boolean isServerRestarted() {
        return this.restarted;
    }
}

