/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.client.helpers.standalone;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.Future;
import org.shaded.jboss.as.controller.client.ModelControllerClient;
import org.shaded.jboss.as.controller.client.helpers.standalone.AddDeploymentPlanBuilder;
import org.shaded.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.shaded.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.shaded.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.shaded.jboss.as.controller.client.helpers.standalone.ReplaceDeploymentPlanBuilder;
import org.shaded.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.shaded.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.shaded.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.shaded.jboss.as.controller.client.helpers.standalone.UndeployDeploymentPlanBuilder;

public class ServerDeploymentHelper {
    private final ServerDeploymentManager deploymentManager;

    public ServerDeploymentHelper(ModelControllerClient client) {
        this.deploymentManager = ServerDeploymentManager.Factory.create(client);
    }

    public ServerDeploymentHelper(ServerDeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    public String deploy(String runtimeName, InputStream input) throws ServerDeploymentException {
        ServerDeploymentPlanResult planResult;
        ArrayList<DeploymentAction> actions = new ArrayList<DeploymentAction>();
        try {
            DeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
            AddDeploymentPlanBuilder addBuilder = builder.add(runtimeName, input);
            actions.add(addBuilder.getLastAction());
            builder = addBuilder.andDeploy();
            actions.add(builder.getLastAction());
            DeploymentPlan plan = builder.build();
            Future<ServerDeploymentPlanResult> future = this.deploymentManager.execute(plan);
            planResult = future.get();
        }
        catch (Exception ex) {
            throw new ServerDeploymentException(ex);
        }
        for (DeploymentAction action : actions) {
            ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(action.getId());
            if (actionResult.getDeploymentException() == null) continue;
            throw new ServerDeploymentException(actionResult);
        }
        return runtimeName;
    }

    public String replace(String runtimeName, String replaceName, InputStream input, boolean removeUndeployed) throws ServerDeploymentException {
        ServerDeploymentPlanResult planResult;
        ArrayList<DeploymentAction> actions = new ArrayList<DeploymentAction>();
        try {
            DeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
            AddDeploymentPlanBuilder addBuilder = builder.add(runtimeName, input);
            actions.add(addBuilder.getLastAction());
            ReplaceDeploymentPlanBuilder replaceBuilder = addBuilder.andReplace(replaceName);
            actions.add(replaceBuilder.getLastAction());
            if (removeUndeployed) {
                builder = replaceBuilder.andRemoveUndeployed();
                actions.add(builder.getLastAction());
            } else {
                builder = replaceBuilder;
            }
            DeploymentPlan plan = builder.build();
            Future<ServerDeploymentPlanResult> future = this.deploymentManager.execute(plan);
            planResult = future.get();
        }
        catch (Exception ex) {
            throw new ServerDeploymentException(ex);
        }
        for (DeploymentAction action : actions) {
            ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(action.getId());
            if (actionResult.getDeploymentException() == null) continue;
            throw new ServerDeploymentException(actionResult);
        }
        return runtimeName;
    }

    public void undeploy(String runtimeName) throws ServerDeploymentException {
        ServerDeploymentPlanResult planResult;
        ArrayList<DeploymentAction> actions = new ArrayList<DeploymentAction>();
        try {
            DeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
            UndeployDeploymentPlanBuilder undeployBuilder = builder.undeploy(runtimeName);
            actions.add(undeployBuilder.getLastAction());
            builder = undeployBuilder.andRemoveUndeployed();
            actions.add(builder.getLastAction());
            DeploymentPlan plan = builder.build();
            Future<ServerDeploymentPlanResult> future = this.deploymentManager.execute(plan);
            planResult = future.get();
        }
        catch (Exception ex) {
            throw new ServerDeploymentException(ex);
        }
        for (DeploymentAction action : actions) {
            ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(action.getId());
            if (actionResult.getDeploymentException() == null) continue;
            throw new ServerDeploymentException(actionResult);
        }
    }

    public static class ServerDeploymentException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final ServerDeploymentActionResult actionResult;

        private ServerDeploymentException(ServerDeploymentActionResult actionResult) {
            super(actionResult.getDeploymentException());
            this.actionResult = actionResult;
        }

        private ServerDeploymentException(Throwable cause) {
            super(cause);
            this.actionResult = null;
        }

        public ServerDeploymentActionResult getActionResult() {
            return this.actionResult;
        }
    }
}

