/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.client.helpers.standalone.impl;

import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import org.shaded.jboss.as.controller.client.helpers.standalone.DeploymentAction;

public class DeploymentActionImpl
implements DeploymentAction,
Serializable {
    private static final long serialVersionUID = 613098200977026475L;
    private final UUID uuid = UUID.randomUUID();
    private final DeploymentAction.Type type;
    private final String deploymentUnitName;
    private final String oldDeploymentUnitName;
    private final InputStream contents;
    private final String newContentFileName;
    private final boolean internalStream;

    public static DeploymentActionImpl getAddAction(String deploymentName, String fileName, InputStream in, boolean internalStream) {
        return new DeploymentActionImpl(DeploymentAction.Type.ADD, deploymentName, fileName, in, internalStream, null);
    }

    public static DeploymentActionImpl getDeployAction(String deploymentName) {
        return new DeploymentActionImpl(DeploymentAction.Type.DEPLOY, deploymentName, null, null, false, null);
    }

    public static DeploymentActionImpl getRedeployAction(String deploymentName) {
        return new DeploymentActionImpl(DeploymentAction.Type.REDEPLOY, deploymentName, null, null, false, null);
    }

    public static DeploymentActionImpl getUndeployAction(String deploymentName) {
        return new DeploymentActionImpl(DeploymentAction.Type.UNDEPLOY, deploymentName, null, null, false, null);
    }

    public static DeploymentActionImpl getReplaceAction(String deploymentName, String replacedName) {
        return new DeploymentActionImpl(DeploymentAction.Type.REPLACE, deploymentName, null, null, false, replacedName);
    }

    public static DeploymentActionImpl getFullReplaceAction(String deploymentName, String fileName, InputStream in, boolean internalStream) {
        return new DeploymentActionImpl(DeploymentAction.Type.FULL_REPLACE, deploymentName, fileName, in, internalStream, null);
    }

    public static DeploymentActionImpl getRemoveAction(String deploymentName) {
        return new DeploymentActionImpl(DeploymentAction.Type.REMOVE, deploymentName, null, null, false, null);
    }

    private DeploymentActionImpl(DeploymentAction.Type type, String deploymentUnitName, String newContentFileName, InputStream contents, boolean internalStream, String replacedDeploymentUnitName) {
        this.type = type;
        this.deploymentUnitName = deploymentUnitName;
        this.newContentFileName = newContentFileName;
        this.contents = contents;
        this.oldDeploymentUnitName = replacedDeploymentUnitName;
        this.internalStream = internalStream;
    }

    @Override
    public UUID getId() {
        return this.uuid;
    }

    @Override
    public DeploymentAction.Type getType() {
        return this.type;
    }

    @Override
    public String getDeploymentUnitUniqueName() {
        return this.deploymentUnitName;
    }

    @Override
    public String getReplacedDeploymentUnitUniqueName() {
        return this.oldDeploymentUnitName;
    }

    public String getNewContentFileName() {
        return this.newContentFileName;
    }

    public InputStream getContentStream() {
        return this.contents;
    }

    public boolean isInternalStream() {
        return this.internalStream;
    }
}

