/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.extension;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.shaded.jboss.as.controller.Extension;
import org.shaded.jboss.as.controller.ExtensionContext;
import org.shaded.jboss.as.controller.ProcessType;
import org.shaded.jboss.as.controller.RunningMode;
import org.shaded.jboss.as.controller.extension.UnsupportedSubsystemDescribeHandler;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.shaded.jboss.as.controller.parsing.ExtensionParsingContext;
import org.shaded.jboss.as.controller.registry.ManagementResourceRegistration;

public abstract class AbstractLegacyExtension
implements Extension {
    private final String extensionName;
    private final List<String> subsystemNames;

    protected AbstractLegacyExtension(String extensionName, String ... subsystemNames) {
        this.extensionName = extensionName;
        this.subsystemNames = Arrays.asList(subsystemNames);
    }

    @Override
    public void initialize(ExtensionContext context) {
        if (context.getProcessType() == ProcessType.DOMAIN_SERVER) {
            ControllerLogger.MGMT_OP_LOGGER.ignoringUnsupportedLegacyExtension(this.subsystemNames, this.extensionName);
            return;
        }
        if (context.getProcessType() == ProcessType.STANDALONE_SERVER) {
            if (context.getRunningMode() == RunningMode.ADMIN_ONLY) {
                ControllerLogger.MGMT_OP_LOGGER.removeUnsupportedLegacyExtension(this.subsystemNames, this.extensionName);
            } else {
                throw new UnsupportedOperationException(ControllerLogger.ROOT_LOGGER.unsupportedLegacyExtension(this.extensionName));
            }
        }
        Set<ManagementResourceRegistration> subsystemRoots = this.initializeLegacyModel(context);
        for (ManagementResourceRegistration subsystemRoot : subsystemRoots) {
            subsystemRoot.registerOperationHandler(GenericSubsystemDescribeHandler.DEFINITION, new UnsupportedSubsystemDescribeHandler(this.extensionName));
        }
    }

    @Override
    public void initializeParsers(ExtensionParsingContext context) {
        if (context.getProcessType() == ProcessType.DOMAIN_SERVER) {
            return;
        }
        if (context.getProcessType() == ProcessType.STANDALONE_SERVER && context.getRunningMode() != RunningMode.ADMIN_ONLY) {
            throw new UnsupportedOperationException(ControllerLogger.ROOT_LOGGER.unsupportedLegacyExtension(this.extensionName));
        }
        this.initializeLegacyParsers(context);
    }

    protected abstract Set<ManagementResourceRegistration> initializeLegacyModel(ExtensionContext var1);

    protected abstract void initializeLegacyParsers(ExtensionParsingContext var1);
}

