/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.operations.common;

import org.shaded.jboss.as.controller.AbstractModelUpdateHandler;
import org.shaded.jboss.as.controller.ExpressionResolver;
import org.shaded.jboss.as.controller.OperationContext;
import org.shaded.jboss.as.controller.OperationDefinition;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.SimpleAttributeDefinition;
import org.shaded.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.shaded.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.shaded.jboss.as.controller.descriptions.common.ControllerResolver;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.as.controller.operations.common.Util;
import org.shaded.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.ModelType;

public class NamespaceAddHandler
extends AbstractModelUpdateHandler {
    private static final String OPERATION_NAME = "add-namespace";
    private static final SimpleAttributeDefinition NAMESPACE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("namespace", ModelType.STRING).setAllowNull(false)).setValidator(new ModelTypeValidator(ModelType.STRING, false))).build();
    private static final SimpleAttributeDefinition URI = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("uri", ModelType.STRING).setAllowNull(false)).setValidator(new ModelTypeValidator(ModelType.STRING, false))).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("add-namespace", ControllerResolver.getResolver("namespaces")).setParameters(NAMESPACE, URI).build();
    public static final NamespaceAddHandler INSTANCE = new NamespaceAddHandler();

    public static ModelNode getAddNamespaceOperation(ModelNode address, String prefix, String uri) {
        ModelNode op = Util.createOperation(OPERATION_NAME, PathAddress.pathAddress(address));
        op.get(NAMESPACE.getName()).set(prefix);
        op.get(URI.getName()).set(uri);
        return op;
    }

    private NamespaceAddHandler() {
    }

    @Override
    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode ns = NAMESPACE.resolveModelAttribute(ExpressionResolver.REJECTING, operation);
        ModelNode uri = URI.resolveModelAttribute(ExpressionResolver.REJECTING, operation);
        ModelNode namespaces = model.get("namespaces");
        this.validate(ns, namespaces);
        namespaces.add(ns.asString(), uri.asString());
    }

    @Override
    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }

    private void validate(ModelNode namespace, ModelNode namespaces) throws OperationFailedException {
        if (namespaces.isDefined()) {
            String namespaceString = namespace.asString();
            for (ModelNode node : namespaces.asList()) {
                if (!namespaceString.equals(node.asProperty().getName())) continue;
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.namespaceAlreadyRegistered(namespaceString, node.asProperty().getValue().asString()));
            }
        }
    }
}

