/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.operations.common;

import org.shaded.jboss.as.controller.OperationContext;
import org.shaded.jboss.as.controller.OperationDefinition;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.OperationStepHandler;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.SimpleAttributeDefinition;
import org.shaded.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.shaded.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.shaded.jboss.as.controller.descriptions.common.ControllerResolver;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.ModelType;
import org.shaded.jboss.dmr.Property;

public class NamespaceRemoveHandler
implements OperationStepHandler {
    private static final String OPERATION_NAME = "remove-namespace";
    private static final SimpleAttributeDefinition NAMESPACE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("namespace", ModelType.STRING).setAllowNull(false)).setValidator(new ModelTypeValidator(ModelType.STRING, false))).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("remove-namespace", ControllerResolver.getResolver("namespaces")).setParameters(NAMESPACE).build();
    public static final NamespaceRemoveHandler INSTANCE = new NamespaceRemoveHandler();

    private NamespaceRemoveHandler() {
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        ModelNode param = NAMESPACE.resolveModelAttribute(context, operation);
        ModelNode namespaces = model.get("namespaces");
        Property toRemove = null;
        ModelNode newList = new ModelNode().setEmptyList();
        String prefix = param.asString();
        if (namespaces.isDefined()) {
            for (Property namespace : namespaces.asPropertyList()) {
                if (prefix.equals(namespace.getName())) {
                    toRemove = namespace;
                    continue;
                }
                newList.add(namespace.getName(), namespace.getValue());
            }
        }
        if (toRemove == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.namespaceNotFound(prefix));
        }
        namespaces.set(newList);
    }
}

