/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.operations.common;

import org.shaded.jboss.as.controller.ExpressionResolver;
import org.shaded.jboss.as.controller.OperationContext;
import org.shaded.jboss.as.controller.OperationDefinition;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.OperationStepHandler;
import org.shaded.jboss.as.controller.SimpleAttributeDefinition;
import org.shaded.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.shaded.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.shaded.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.shaded.jboss.as.controller.descriptions.common.ControllerResolver;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.as.controller.parsing.ParseUtils;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.ModelType;

public class ResolveExpressionHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "resolve-expression";
    public static final ResolveExpressionHandler INSTANCE = new ResolveExpressionHandler();
    public static final SimpleAttributeDefinition EXPRESSION = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("expression", ModelType.STRING, true).setAllowExpression(true)).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("resolve-expression", ControllerResolver.getResolver("core")).addParameter(EXPRESSION).setReplyType(ModelType.STRING).allowReturnNull().setReadOnly().setRuntimeOnly().addAccessConstraint(SensitiveTargetAccessConstraintDefinition.SYSTEM_PROPERTY).build();

    private ResolveExpressionHandler() {
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode toResolve = EXPRESSION.validateOperation(operation);
                if (toResolve.getType() == ModelType.STRING) {
                    toResolve = ParseUtils.parsePossibleExpression(toResolve.asString());
                }
                try {
                    ModelNode resolved = ExpressionResolver.SIMPLE.resolveExpressions(toResolve);
                    ModelNode result = context.getResult();
                    if (resolved.isDefined()) {
                        result.set(resolved.asString());
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
                catch (SecurityException e) {
                    throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noPermissionToResolveExpression(toResolve, e));
                }
                catch (IllegalStateException e) {
                    throw ControllerLogger.ROOT_LOGGER.cannotResolveExpression(toResolve.asString());
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

