/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.operations.common;

import org.shaded.jboss.as.controller.AbstractModelUpdateHandler;
import org.shaded.jboss.as.controller.ExpressionResolver;
import org.shaded.jboss.as.controller.OperationContext;
import org.shaded.jboss.as.controller.OperationDefinition;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.SimpleAttributeDefinition;
import org.shaded.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.shaded.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.shaded.jboss.as.controller.descriptions.common.ControllerResolver;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.as.controller.operations.common.Util;
import org.shaded.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.ModelType;
import org.shaded.jboss.dmr.Property;

public class SchemaLocationAddHandler
extends AbstractModelUpdateHandler {
    private static final String OPERATION_NAME = "add-schema-location";
    private static final SimpleAttributeDefinition SCHEMA_LOCATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("schema-location", ModelType.STRING).setAllowNull(false)).setValidator(new ModelTypeValidator(ModelType.STRING, false))).build();
    private static final SimpleAttributeDefinition URI = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("uri", ModelType.STRING).setAllowNull(false)).setValidator(new ModelTypeValidator(ModelType.STRING, false))).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("add-schema-location", ControllerResolver.getResolver("schema-locations")).setParameters(SCHEMA_LOCATION, URI).build();
    public static final SchemaLocationAddHandler INSTANCE = new SchemaLocationAddHandler();

    public static ModelNode getAddSchemaLocationOperation(ModelNode address, String schemaUrl, String schemaLocation) {
        ModelNode op = Util.createOperation(OPERATION_NAME, PathAddress.pathAddress(address));
        op.get(URI.getName()).set(schemaUrl);
        op.get(SCHEMA_LOCATION.getName()).set(schemaLocation);
        return op;
    }

    private SchemaLocationAddHandler() {
    }

    @Override
    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode uri = URI.resolveModelAttribute(ExpressionResolver.REJECTING, operation);
        ModelNode location = SCHEMA_LOCATION.resolveModelAttribute(ExpressionResolver.REJECTING, operation);
        ModelNode locations = model.get("schema-locations");
        this.validate(uri, locations);
        locations.add(uri.asString(), location.asString());
    }

    @Override
    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }

    private void validate(ModelNode uri, ModelNode locations) throws OperationFailedException {
        if (locations.isDefined()) {
            String uriString = uri.asString();
            for (Property prop : locations.asPropertyList()) {
                if (!uriString.equals(prop.getName())) continue;
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.schemaAlreadyRegistered(uriString, prop.getValue().asString()));
            }
        }
    }
}

