/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.operations.common;

import org.shaded.jboss.as.controller.AttributeDefinition;
import org.shaded.jboss.as.controller.OperationContext;
import org.shaded.jboss.as.controller.OperationDefinition;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.OperationStepHandler;
import org.shaded.jboss.as.controller.SimpleAttributeDefinition;
import org.shaded.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.shaded.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.shaded.jboss.as.controller.StringListAttributeDefinition;
import org.shaded.jboss.as.controller.access.AuthorizationResult;
import org.shaded.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.shaded.jboss.as.controller.descriptions.common.ControllerResolver;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.as.controller.persistence.ConfigurationPersister;
import org.shaded.jboss.as.controller.registry.OperationEntry;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.ModelType;

public class SnapshotListHandler
implements OperationStepHandler {
    private static final String OPERATION_NAME = "list-snapshots";
    private static final SimpleAttributeDefinition DIRECTORY = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("directory", ModelType.STRING).setAllowNull(false)).build();
    private static final AttributeDefinition NAMES = new StringListAttributeDefinition.Builder("names").build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("list-snapshots", ControllerResolver.getResolver("snapshot")).setReplyParameters(DIRECTORY, NAMES).setReadOnly().setRuntimeOnly().withFlag(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY).addAccessConstraint(SensitiveTargetAccessConstraintDefinition.SNAPSHOTS).build();
    private final ConfigurationPersister persister;

    public SnapshotListHandler(ConfigurationPersister persister) {
        this.persister = persister;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        AuthorizationResult authorizationResult = context.authorize(operation);
        if (authorizationResult.getDecision() == AuthorizationResult.Decision.DENY) {
            throw ControllerLogger.ROOT_LOGGER.unauthorized(operation.get("operation").asString(), context.getCurrentAddress(), authorizationResult.getExplanation());
        }
        try {
            ConfigurationPersister.SnapshotInfo info = this.persister.listSnapshots();
            ModelNode result = context.getResult();
            result.get("directory").set(info.getSnapshotDirectory());
            result.get("names").setEmptyList();
            for (String name : info.names()) {
                result.get("names").add(name);
            }
        }
        catch (Exception e) {
            throw new OperationFailedException(e);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }
}

