/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.operations.global;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.PathElement;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.Property;

class FilteredData {
    private final int baseAddressLength;
    private Map<PathAddress, ResourceData> map;

    FilteredData(PathAddress baseAddress) {
        this.baseAddressLength = baseAddress.size();
    }

    void addReadRestrictedAttribute(PathAddress fullAddress, String attribute) {
        ResourceData rd = this.getResourceData(fullAddress);
        if (rd.attributes == null) {
            rd.attributes = new HashSet();
        }
        rd.attributes.add(attribute);
    }

    void addReadRestrictedResource(PathAddress fullAddress) {
        assert (fullAddress.size() > 0) : "cannot filter root resource";
        ResourceData rd = this.getResourceData(fullAddress.subAddress(0, fullAddress.size() - 1));
        if (rd.children == null) {
            rd.children = new HashSet();
        }
        rd.children.add(fullAddress.getLastElement());
    }

    void addAccessRestrictedResource(PathAddress fullAddress) {
        assert (fullAddress.size() > 0) : "cannot filter root resource";
        ResourceData rd = this.getResourceData(fullAddress.subAddress(0, fullAddress.size() - 1));
        if (rd.childTypes == null) {
            rd.childTypes = new HashSet();
        }
        rd.childTypes.add(fullAddress.getLastElement());
    }

    boolean hasFilteredData() {
        return this.map != null;
    }

    boolean isFilteredResource(PathAddress parent, PathElement child) {
        ResourceData rd;
        boolean result = false;
        ResourceData resourceData = rd = this.map == null ? null : this.map.get(parent);
        if (rd != null) {
            result = rd.children != null && rd.children.contains(child) || rd.childTypes != null && rd.childTypes.contains(child);
        }
        return result;
    }

    boolean isAddressFiltered(PathAddress parent, PathElement child) {
        ResourceData rd;
        boolean result = false;
        ResourceData resourceData = rd = this.map == null ? null : this.map.get(parent);
        if (rd != null) {
            result = rd.childTypes != null && rd.childTypes.contains(child);
        }
        return result;
    }

    ModelNode toModelNode() {
        ModelNode result = null;
        if (this.map != null) {
            result = new ModelNode();
            for (Map.Entry<PathAddress, ResourceData> entry : this.map.entrySet()) {
                ModelNode item = new ModelNode();
                PathAddress pa = entry.getKey();
                item.get("absolute-address").set(pa.toModelNode());
                ResourceData rd = entry.getValue();
                item.get("relative-address").set(pa.subAddress(this.baseAddressLength).toModelNode());
                ModelNode attrs = new ModelNode().setEmptyList();
                if (rd.attributes != null) {
                    for (Object attr : rd.attributes) {
                        attrs.add((String)attr);
                    }
                }
                if (attrs.asInt() > 0) {
                    item.get("filtered-attributes").set(attrs);
                }
                ModelNode children = new ModelNode().setEmptyList();
                if (rd.children != null) {
                    Object attr;
                    attr = rd.children.iterator();
                    while (attr.hasNext()) {
                        PathElement pe = (PathElement)attr.next();
                        children.add(new Property(pe.getKey(), new ModelNode(pe.getValue())));
                    }
                }
                if (children.asInt() > 0) {
                    item.get("unreadable-children").set(children);
                }
                ModelNode childTypes = new ModelNode().setEmptyList();
                if (rd.childTypes != null) {
                    HashSet<String> added = new HashSet<String>();
                    for (PathElement pe : rd.childTypes) {
                        if (!added.add(pe.getKey())) continue;
                        childTypes.add(pe.getKey());
                    }
                }
                if (childTypes.asInt() > 0) {
                    item.get("filtered-children-types").set(childTypes);
                }
                result.add(item);
            }
        }
        return result;
    }

    void populate(ModelNode modelNode, PathAddress addressPrefix) {
        for (ModelNode item : modelNode.asList()) {
            PathElement pe;
            PathAddress absAddr = addressPrefix.append(PathAddress.pathAddress(item.get("absolute-address")));
            if (item.hasDefined("filtered-attributes")) {
                for (ModelNode node : item.get("filtered-attributes").asList()) {
                    this.addReadRestrictedAttribute(absAddr, node.asString());
                }
            }
            if (item.hasDefined("unreadable-children")) {
                for (Property prop : item.get("unreadable-children").asPropertyList()) {
                    pe = PathElement.pathElement(prop.getName(), prop.getValue().asString());
                    this.addReadRestrictedResource(PathAddress.pathAddress(absAddr, pe));
                }
            }
            if (!item.hasDefined("filtered-children-types")) continue;
            for (ModelNode type : item.get("filtered-children-types").asList()) {
                pe = PathElement.pathElement(type.asString());
                this.addAccessRestrictedResource(PathAddress.pathAddress(absAddr, pe));
            }
        }
    }

    private ResourceData getResourceData(PathAddress fullAddress) {
        ResourceData result;
        if (this.map == null) {
            this.map = new LinkedHashMap<PathAddress, ResourceData>();
        }
        if ((result = this.map.get(fullAddress)) == null) {
            result = new ResourceData();
            this.map.put(fullAddress, result);
        }
        return result;
    }

    private static class ResourceData {
        private Set<String> attributes;
        private Set<PathElement> children;
        private Set<PathElement> childTypes;

        private ResourceData() {
        }
    }
}

