/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.operations.validation;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.ModelType;

public class InetAddressValidator
extends ModelTypeValidator {
    public InetAddressValidator(boolean nullable, boolean allowExpressions) {
        super(ModelType.STRING, nullable, allowExpressions, true);
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION) {
            String str = value.asString();
            try {
                InetAddress.getByName(str);
            }
            catch (UnknownHostException e) {
                throw new OperationFailedException(e.toString());
            }
        }
    }
}

