/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.persistence;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.shaded.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.shaded.jboss.as.controller.persistence.ExposedByteArrayOutputStream;
import org.shaded.jboss.dmr.ModelNode;
import org.xnio.IoUtils;

class FilePersistenceUtils {
    FilePersistenceUtils() {
    }

    static File createTempFile(File fileName) {
        return new File(fileName.getParentFile(), fileName.getName() + ".tmp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExposedByteArrayOutputStream marshalXml(AbstractConfigurationPersister persister, ModelNode model) throws ConfigurationPersistenceException {
        ExposedByteArrayOutputStream marshalled = new ExposedByteArrayOutputStream(8192);
        try {
            try {
                BufferedOutputStream output = new BufferedOutputStream(marshalled);
                persister.marshallAsXml(model, output);
                output.close();
                marshalled.close();
            }
            finally {
                IoUtils.safeClose((Closeable)marshalled);
            }
        }
        catch (Exception e) {
            throw ControllerLogger.ROOT_LOGGER.failedToMarshalConfiguration(e);
        }
        return marshalled;
    }

    static void copyFile(File file, File backup) throws IOException {
        Files.copy(file.toPath(), backup.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
    }

    static void rename(File file, File to) throws IOException {
        if (!file.renameTo(to) && file.exists()) {
            FilePersistenceUtils.copyFile(file, to);
        }
    }

    static void moveTempFileToMain(File tempFileName, File fileName) throws ConfigurationPersistenceException {
        try {
            Files.move(tempFileName.toPath(), fileName.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw ControllerLogger.ROOT_LOGGER.failedToRenameTempFile(e, tempFileName, fileName);
        }
    }

    static void deleteFile(File file) {
        if (file.exists() && !file.delete() && file.exists()) {
            file.deleteOnExit();
            throw new IllegalStateException(ControllerLogger.ROOT_LOGGER.couldNotDeleteFile(file));
        }
    }

    static File writeToTempFile(ExposedByteArrayOutputStream marshalled, File tempFileName, File fileName) throws IOException {
        Path targetPath = tempFileName.toPath();
        FilePersistenceUtils.deleteFile(tempFileName);
        try {
            FilePersistenceUtils.createTempFileWithAttributes(targetPath, fileName);
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        try (ByteArrayInputStream is = marshalled.getInputStream();){
            Files.copy(is, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
        return tempFileName;
    }

    static Path createTempFileWithAttributes(Path tempFilePath, File fileName) throws IOException {
        Path exisitingFilePath = fileName.toPath();
        ArrayList<FileAttribute<Collection<Object>>> attributes = new ArrayList<FileAttribute<Collection<Object>>>(2);
        attributes.addAll(FilePersistenceUtils.getPosixAttributes(exisitingFilePath));
        attributes.addAll(FilePersistenceUtils.getAclAttributes(exisitingFilePath));
        if (!attributes.isEmpty()) {
            try {
                return Files.createFile(tempFilePath, attributes.toArray(new FileAttribute[attributes.size()]));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return Files.createFile(tempFilePath, new FileAttribute[0]);
    }

    private static List<FileAttribute<Set<PosixFilePermission>>> getPosixAttributes(Path file) throws IOException {
        PosixFileAttributeView posixView;
        if (Files.exists(file, new LinkOption[0]) && Files.getFileStore(file).supportsFileAttributeView(PosixFileAttributeView.class) && (posixView = Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0])) != null) {
            return Collections.singletonList(PosixFilePermissions.asFileAttribute(posixView.readAttributes().permissions()));
        }
        return Collections.emptyList();
    }

    private static List<FileAttribute<List<AclEntry>>> getAclAttributes(Path file) throws IOException {
        AclFileAttributeView aclView;
        if (Files.exists(file, new LinkOption[0]) && Files.getFileStore(file).supportsFileAttributeView(AclFileAttributeView.class) && (aclView = Files.getFileAttributeView(file, AclFileAttributeView.class, new LinkOption[0])) != null) {
            final List<AclEntry> entries = aclView.getAcl();
            return Collections.singletonList(new FileAttribute<List<AclEntry>>(){

                @Override
                public List<AclEntry> value() {
                    return entries;
                }

                @Override
                public String name() {
                    return "acl:acl";
                }
            });
        }
        return Collections.emptyList();
    }
}

