/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.registry;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.shaded.jboss.as.controller.OperationStepHandler;
import org.shaded.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.shaded.jboss.as.controller.descriptions.DescriptionProvider;

public final class OperationEntry {
    private final OperationStepHandler operationHandler;
    private final DescriptionProvider descriptionProvider;
    private final EntryType type;
    private final EnumSet<Flag> flags;
    private final boolean inherited;
    private final List<AccessConstraintDefinition> accessConstraints;

    OperationEntry(OperationStepHandler operationHandler, DescriptionProvider descriptionProvider, boolean inherited, EntryType type, EnumSet<Flag> flags, List<AccessConstraintDefinition> accessConstraints) {
        this.operationHandler = operationHandler;
        this.descriptionProvider = descriptionProvider;
        this.inherited = inherited;
        this.type = type;
        this.flags = flags == null ? EnumSet.noneOf(Flag.class) : flags;
        this.accessConstraints = accessConstraints == null ? Collections.emptyList() : accessConstraints;
    }

    OperationEntry(OperationStepHandler operationHandler, DescriptionProvider descriptionProvider, boolean inherited, EntryType type) {
        this(operationHandler, descriptionProvider, inherited, type, EnumSet.noneOf(Flag.class), null);
    }

    public OperationStepHandler getOperationHandler() {
        return this.operationHandler;
    }

    public DescriptionProvider getDescriptionProvider() {
        return this.descriptionProvider;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public EntryType getType() {
        return this.type;
    }

    public EnumSet<Flag> getFlags() {
        return this.flags == null ? EnumSet.noneOf(Flag.class) : this.flags.clone();
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    public static enum Flag {
        READ_ONLY,
        RESTART_NONE,
        RESTART_JVM,
        RESTART_ALL_SERVICES,
        RESTART_RESOURCE_SERVICES,
        DOMAIN_PUSH_TO_SERVERS,
        HOST_CONTROLLER_ONLY,
        MASTER_HOST_CONTROLLER_ONLY,
        RUNTIME_ONLY;

    }

    public static enum EntryType {
        PUBLIC,
        PRIVATE;

    }
}

