/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.remote;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.shaded.jboss.as.controller.client.Operation;
import org.shaded.jboss.as.controller.remote.Pipe;
import org.shaded.jboss.as.protocol.StreamUtils;
import org.shaded.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.shaded.jboss.as.protocol.mgmt.ActiveOperation;
import org.shaded.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.shaded.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.shaded.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.shaded.jboss.as.protocol.mgmt.ProtocolUtils;
import org.shaded.jboss.dmr.ModelNode;

class OperationAttachmentsProxy
implements Operation {
    private final ModelNode operation;
    private final List<ProxiedInputStream> proxiedStreams;

    private OperationAttachmentsProxy(ModelNode operation, List<ProxiedInputStream> proxiedStreams) {
        this.operation = operation;
        this.proxiedStreams = proxiedStreams;
    }

    static OperationAttachmentsProxy create(ModelNode operation, ManagementChannelAssociation channelAssociation, int batchId, int size) {
        return new OperationAttachmentsProxy(operation, OperationAttachmentsProxy.getProxiedStreams(channelAssociation, batchId, size));
    }

    private static List<ProxiedInputStream> getProxiedStreams(ManagementChannelAssociation channelAssociation, int batchId, int size) {
        ArrayList<ProxiedInputStream> proxiedStreams = new ArrayList<ProxiedInputStream>(size);
        for (int i = 0; i < size; ++i) {
            proxiedStreams.add(new ProxiedInputStream(channelAssociation, batchId, i));
        }
        return proxiedStreams;
    }

    @Override
    public boolean isAutoCloseStreams() {
        return false;
    }

    @Override
    public List<InputStream> getInputStreams() {
        ArrayList<ProxiedInputStream> result = new ArrayList<ProxiedInputStream>();
        result.addAll(this.proxiedStreams);
        return Collections.unmodifiableList(result);
    }

    @Override
    public void close() throws IOException {
    }

    void shutdown() {
        for (ProxiedInputStream stream : this.proxiedStreams) {
            stream.shutdown(null);
        }
    }

    @Override
    public ModelNode getOperation() {
        return this.operation;
    }

    @Override
    @Deprecated
    public final Operation clone() {
        return new OperationAttachmentsProxy(this.operation, this.proxiedStreams);
    }

    @Override
    @Deprecated
    public Operation clone(ModelNode operation) {
        return new OperationAttachmentsProxy(operation, this.proxiedStreams);
    }

    private static class ProxiedInputStream
    extends InputStream {
        static final int BUFFER_SIZE = 8192;
        private final int index;
        private final int batchId;
        private final Pipe pipe;
        private final ManagementChannelAssociation channelAssociation;
        private boolean initialized;
        private volatile Throwable error;

        ProxiedInputStream(ManagementChannelAssociation channelAssociation, int batchId, int index) {
            this.channelAssociation = channelAssociation;
            this.batchId = batchId;
            this.index = index;
            this.pipe = new Pipe(8192);
        }

        @Override
        public int read() throws IOException {
            this.prepareForRead();
            return this.pipe.getIn().read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.prepareForRead();
            return this.pipe.getIn().read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            IOException ex = null;
            try {
                this.pipe.getOut().close();
            }
            catch (IOException e) {
                ex = e;
            }
            try {
                this.pipe.getIn().close();
            }
            catch (IOException e) {
                ex = e;
            }
            if (ex != null) {
                throw ex;
            }
        }

        private void prepareForRead() throws IOException {
            this.initializeBytes();
            this.throwIfError();
        }

        private void initializeBytes() {
            if (!this.initialized) {
                this.initialized = true;
                try {
                    final OutputStream os = this.pipe.getOut();
                    this.channelAssociation.executeRequest(this.batchId, new AbstractManagementRequest<Object, Object>(){

                        @Override
                        public byte getOperationType() {
                            return 76;
                        }

                        @Override
                        protected void sendRequest(ActiveOperation.ResultHandler<Object> resultHandler, ManagementRequestContext<Object> context, FlushableDataOutput output) throws IOException {
                            output.write(102);
                            output.writeInt(index);
                        }

                        @Override
                        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Object> resultHandler, ManagementRequestContext<Object> context) throws IOException {
                            try {
                                int len;
                                ProtocolUtils.expectHeader(input, 103);
                                int size = input.readInt();
                                ProtocolUtils.expectHeader(input, 104);
                                byte[] buffer = new byte[8192];
                                for (int totalRead = 0; totalRead < size; totalRead += len) {
                                    len = Math.min(size - totalRead, buffer.length);
                                    input.readFully(buffer, 0, len);
                                    os.write(buffer, 0, len);
                                }
                                os.close();
                            }
                            catch (IOException e) {
                                this.shutdown(e);
                                throw e;
                            }
                        }
                    });
                }
                catch (IOException e) {
                    this.shutdown(e);
                }
            }
        }

        private void throwIfError() throws IOException {
            if (this.error != null) {
                if (this.error instanceof IOException) {
                    throw (IOException)this.error;
                }
                throw new IOException(this.error);
            }
        }

        private void shutdown(Throwable error) {
            StreamUtils.safeClose(this);
            this.error = error;
        }
    }
}

