/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.services.path;

import org.shaded.jboss.as.controller.OperationContext;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.OperationStepHandler;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.SimpleAttributeDefinition;
import org.shaded.jboss.as.controller.operations.common.Util;
import org.shaded.jboss.as.controller.registry.Resource;
import org.shaded.jboss.as.controller.services.path.PathManager;
import org.shaded.jboss.as.controller.services.path.PathManagerService;
import org.shaded.jboss.as.controller.services.path.PathResourceDefinition;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.msc.service.ServiceController;
import org.shaded.jboss.msc.service.ServiceTarget;

public class PathAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add";
    private final SimpleAttributeDefinition pathAttribute;
    private final PathManagerService pathManager;
    private final boolean services;

    public static ModelNode getAddPathOperation(PathAddress address, ModelNode path, ModelNode relativeTo) {
        ModelNode op = Util.createAddOperation(address);
        if (path.isDefined()) {
            op.get(PathResourceDefinition.PATH_SPECIFIED.getName()).set(path);
        }
        if (relativeTo.isDefined()) {
            op.get(PathResourceDefinition.RELATIVE_TO.getName()).set(relativeTo);
        }
        return op;
    }

    protected PathAddHandler(PathManagerService pathManager, boolean services, SimpleAttributeDefinition pathAttribute) {
        this.pathManager = pathManager;
        this.services = services;
        this.pathAttribute = pathAttribute;
    }

    static PathAddHandler createNamedInstance(PathManagerService pathManager) {
        return new PathAddHandler(pathManager, false, PathResourceDefinition.PATH_NAMED);
    }

    static PathAddHandler createSpecifiedInstance(PathManagerService pathManager) {
        return new PathAddHandler(pathManager, true, PathResourceDefinition.PATH_SPECIFIED);
    }

    static PathAddHandler createSpecifiedNoServicesInstance(PathManagerService pathManager) {
        return new PathAddHandler(pathManager, false, PathResourceDefinition.PATH_SPECIFIED);
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        final String name = context.getCurrentAddressValue();
        this.pathAttribute.validateAndSet(operation, model);
        PathResourceDefinition.RELATIVE_TO.validateAndSet(operation, model);
        if (this.services) {
            final String path = PathAddHandler.getPathValue(context, PathResourceDefinition.PATH_SPECIFIED, model);
            final String relativeTo = PathAddHandler.getPathValue(context, PathResourceDefinition.RELATIVE_TO, model);
            final PathManagerService.PathEventContextImpl pathEventContext = this.pathManager.checkRestartRequired(context, name, PathManager.Event.ADDED);
            if (pathEventContext.isInstallServices()) {
                this.pathManager.addPathEntry(name, path, relativeTo, false);
            }
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController<?> legacyService;
                    if (pathEventContext.isInstallServices()) {
                        ServiceTarget target = context.getServiceTarget();
                        legacyService = relativeTo == null ? PathAddHandler.this.pathManager.addAbsolutePathService(target, name, path) : PathAddHandler.this.pathManager.addRelativePathService(target, name, path, false, relativeTo);
                    } else {
                        legacyService = null;
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            PathAddHandler.this.pathManager.removePathService(context, name);
                            if (pathEventContext.isInstallServices()) {
                                if (legacyService != null) {
                                    context.removeService(legacyService.getName());
                                }
                            } else {
                                pathEventContext.revert();
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
            context.completeStep(new OperationContext.RollbackHandler(){

                @Override
                public void handleRollback(OperationContext context, ModelNode operation) {
                    if (pathEventContext.isInstallServices()) {
                        try {
                            PathAddHandler.this.pathManager.removePathEntry(name, false);
                        }
                        catch (OperationFailedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        } else {
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    static String getPathValue(OperationContext context, SimpleAttributeDefinition def, ModelNode model) throws OperationFailedException {
        ModelNode resolved = def.resolveModelAttribute(context, model);
        return resolved.isDefined() ? resolved.asString() : null;
    }
}

