/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.transform.description;

import java.util.Collections;
import java.util.List;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.transform.description.AttributeConverter;
import org.shaded.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.shaded.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.shaded.jboss.as.controller.transform.description.RejectedAttributesLogContext;
import org.shaded.jboss.as.controller.transform.description.TransformationRule;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.ModelType;

class AttributeTransformationDescription {
    final String name;
    final List<RejectAttributeChecker> checks;
    final String newName;
    final DiscardAttributeChecker discardChecker;
    final AttributeConverter converter;

    AttributeTransformationDescription(String name, List<RejectAttributeChecker> checks, String newName, DiscardAttributeChecker discardChecker, AttributeConverter converter) {
        this.name = name;
        this.checks = checks != null ? checks : Collections.emptyList();
        this.newName = newName;
        this.discardChecker = discardChecker;
        this.converter = converter;
    }

    boolean shouldDiscard(PathAddress address, ModelNode attributeValue, ModelNode operation, TransformationRule.AbstractChainedContext context) {
        if (this.discardChecker == null) {
            return false;
        }
        if (this.discardChecker.isDiscardUndefined() && !attributeValue.isDefined()) {
            return true;
        }
        if (!this.discardChecker.isDiscardExpressions() && attributeValue.getType() == ModelType.EXPRESSION) {
            return false;
        }
        return operation != null ? this.discardChecker.isOperationParameterDiscardable(address, this.name, attributeValue, operation, context.getContext()) : this.discardChecker.isResourceAttributeDiscardable(address, this.name, attributeValue, context.getContext());
    }

    String getNewName() {
        return this.newName;
    }

    void rejectAttributes(RejectedAttributesLogContext rejectedAttributes, ModelNode attributeValue) {
        for (RejectAttributeChecker checker : this.checks) {
            rejectedAttributes.checkAttribute(checker, this.name, attributeValue);
        }
    }

    void isExistingValue(PathAddress address, ModelNode attributeValue, ModelNode operation, TransformationRule.AbstractChainedContext context) {
        if (this.converter != null) {
            if (operation != null) {
                this.converter.convertOperationParameter(address, this.name, attributeValue, operation, context.getContext());
            } else {
                this.converter.convertResourceAttribute(address, this.name, attributeValue, context.getContext());
            }
        }
    }

    void convertValue(PathAddress address, ModelNode attributeValue, ModelNode operation, TransformationRule.AbstractChainedContext context) {
        if (this.converter != null) {
            if (operation != null) {
                this.converter.convertOperationParameter(address, this.name, attributeValue, operation, context.getContext());
            } else {
                this.converter.convertResourceAttribute(address, this.name, attributeValue, context.getContext());
            }
        }
    }
}

