/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.transform.description;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.shaded.jboss.as.controller.PathElement;
import org.shaded.jboss.as.controller.registry.OperationTransformerRegistry;
import org.shaded.jboss.as.controller.transform.OperationTransformer;
import org.shaded.jboss.as.controller.transform.PathAddressTransformer;
import org.shaded.jboss.as.controller.transform.ResourceTransformer;
import org.shaded.jboss.as.controller.transform.TransformerEntry;
import org.shaded.jboss.as.controller.transform.description.TransformationDescription;

class ChainedPlaceholderResolver
implements OperationTransformerRegistry.PlaceholderResolver {
    private final TransformationDescription description;
    private final Map<String, SubRegistry> subRegistries;

    private ChainedPlaceholderResolver(TransformationDescription description, Map<String, SubRegistry> subRegistries) {
        this.description = description;
        this.subRegistries = subRegistries;
    }

    static ChainedPlaceholderResolver create(TransformationDescription root) {
        HashMap childResolvers = new HashMap();
        for (TransformationDescription childDesc : root.getChildren()) {
            ChainedPlaceholderResolver childResolver = ChainedPlaceholderResolver.create(childDesc);
            PathElement pathElement = childDesc.getPath();
            HashMap<String, ChainedPlaceholderResolver> subMap = (HashMap<String, ChainedPlaceholderResolver>)childResolvers.get(pathElement.getKey());
            if (subMap == null) {
                subMap = new HashMap<String, ChainedPlaceholderResolver>();
                childResolvers.put(pathElement.getKey(), subMap);
            }
            if (subMap.containsKey(pathElement.getValue())) continue;
            subMap.put(pathElement.getValue(), childResolver);
        }
        HashMap subRegistries = new HashMap();
        for (Map.Entry keyEntry : childResolvers.entrySet()) {
            subRegistries.put(keyEntry.getKey(), new SubRegistry(Collections.unmodifiableMap((Map)keyEntry.getValue())));
        }
        return new ChainedPlaceholderResolver(root, Collections.unmodifiableMap(subRegistries));
    }

    TransformationDescription getDescription() {
        return this.description;
    }

    @Override
    public OperationTransformerRegistry.OperationTransformerEntry resolveOperationTransformer(Iterator<PathElement> iterator, String operationName) {
        OperationTransformerRegistry.OperationTransformerEntry entry;
        if (!iterator.hasNext()) {
            if (this.description.getDiscardedOperations().contains(operationName)) {
                return new OperationTransformerRegistry.OperationTransformerEntry(OperationTransformer.DISCARD, this.description.isInherited());
            }
            OperationTransformer transformer = this.description.getOperationTransformers().get(operationName);
            if (transformer == null) {
                return new OperationTransformerRegistry.OperationTransformerEntry(this.description.getOperationTransformer(), this.description.isInherited());
            }
            return new OperationTransformerRegistry.OperationTransformerEntry(transformer, this.description.isInherited());
        }
        PathElement element = iterator.next();
        String key = element.getKey();
        SubRegistry registry = this.subRegistries.get(key);
        if (registry != null && (entry = registry.resolveTransformer(iterator, element.getValue(), operationName)) != null) {
            return entry;
        }
        OperationTransformer transformer = this.description.getOperationTransformers().get(operationName);
        if (transformer != null && this.description.isInherited()) {
            return new OperationTransformerRegistry.OperationTransformerEntry(transformer, this.description.isInherited());
        }
        transformer = this.description.getOperationTransformer();
        if (transformer != null && this.description.isInherited()) {
            return new OperationTransformerRegistry.OperationTransformerEntry(transformer, this.description.isInherited());
        }
        return null;
    }

    @Override
    public TransformerEntry resolveTransformerEntry(Iterator<PathElement> iterator) {
        if (!iterator.hasNext()) {
            return this.getTransformerEntry();
        }
        PathElement element = iterator.next();
        SubRegistry sub = this.subRegistries.get(element.getKey());
        if (sub == null) {
            return null;
        }
        ChainedPlaceholderResolver registry = sub.get(element.getValue());
        if (registry == null) {
            return null;
        }
        return registry.resolveTransformerEntry(iterator);
    }

    @Override
    public void resolvePathTransformers(Iterator<PathElement> iterator, List<PathAddressTransformer> list) {
        if (iterator.hasNext()) {
            ChainedPlaceholderResolver reg;
            PathElement element = iterator.next();
            SubRegistry sub = this.subRegistries.get(element.getKey());
            if (sub != null && (reg = sub.get(element.getValue())) != null) {
                list.add(reg.description.getPathAddressTransformer());
                reg.resolvePathTransformers(iterator, list);
                return;
            }
            list.add(PathAddressTransformer.DEFAULT);
        } else {
            list.add(this.description.getPathAddressTransformer());
        }
    }

    private ChainedPlaceholderResolver resolveChild(Iterator<PathElement> iterator) {
        if (!iterator.hasNext()) {
            return this;
        }
        PathElement element = iterator.next();
        SubRegistry sub = this.subRegistries.get(element.getKey());
        if (sub == null) {
            return null;
        }
        return sub.get(element.getValue(), iterator);
    }

    private TransformerEntry getTransformerEntry() {
        return new TransformerEntry(){

            @Override
            public PathAddressTransformer getPathTransformation() {
                return ChainedPlaceholderResolver.this.description.getPathAddressTransformer();
            }

            @Override
            public ResourceTransformer getResourceTransformer() {
                return ChainedPlaceholderResolver.this.description.getResourceTransformer();
            }
        };
    }

    private static class SubRegistry {
        private volatile Map<String, ChainedPlaceholderResolver> entries;

        SubRegistry(Map<String, ChainedPlaceholderResolver> entries) {
            this.entries = entries;
        }

        public OperationTransformerRegistry.OperationTransformerEntry resolveTransformer(Iterator<PathElement> iterator, String value, String operationName) {
            ChainedPlaceholderResolver reg = this.get(value);
            if (reg == null) {
                return null;
            }
            return reg.resolveOperationTransformer(iterator, operationName);
        }

        ChainedPlaceholderResolver get(String value) {
            ChainedPlaceholderResolver entry = this.entries.get(value);
            if (entry == null && (entry = this.entries.get("*")) == null) {
                return null;
            }
            return entry;
        }

        ChainedPlaceholderResolver get(String value, Iterator<PathElement> iterator) {
            ChainedPlaceholderResolver entry = this.entries.get(value);
            if (entry == null && (entry = this.entries.get("*")) == null) {
                return null;
            }
            return entry.resolveChild(iterator);
        }
    }
}

