/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.protocol.mgmt;

import java.io.IOException;
import org.shaded.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.shaded.jboss.as.protocol.ProtocolConnectionManager;
import org.shaded.jboss.as.protocol.StreamUtils;
import org.shaded.jboss.as.protocol.logging.ProtocolLogger;
import org.shaded.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.shaded.jboss.remoting3.Channel;
import org.shaded.jboss.remoting3.CloseHandler;
import org.shaded.jboss.remoting3.Connection;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public abstract class FutureManagementChannel
extends ManagementClientChannelStrategy
implements ProtocolConnectionManager.ConnectionOpenHandler {
    private final Object lock = new Object();
    private volatile Channel channel;
    private volatile State state = State.OPEN;

    @Override
    public Channel getChannel() throws IOException {
        Channel channel = this.channel;
        if (channel == null && this.state != State.OPEN) {
            throw FutureManagementChannel.channelClosed();
        }
        return channel;
    }

    protected static IOException channelClosed() {
        return ProtocolLogger.ROOT_LOGGER.channelClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == State.CLOSED) {
                return;
            }
            this.state = State.CLOSED;
            StreamUtils.safeClose(this.channel);
            this.lock.notifyAll();
        }
    }

    public State getState() {
        return this.state;
    }

    protected boolean isConnected() {
        return this.channel != null && this.state != State.CLOSED;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Channel awaitChannel() throws IOException {
        Channel channel = this.channel;
        if (channel != null) {
            return channel;
        }
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (this.state == State.CLOSED) {
                    throw ProtocolLogger.ROOT_LOGGER.channelClosed();
                }
                channel = this.channel;
                if (channel != null) {
                    return channel;
                }
                if (this.state == State.CLOSING) {
                    throw ProtocolLogger.ROOT_LOGGER.channelClosed();
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean prepareClose() {
        Object object = this.lock;
        synchronized (object) {
            State state = this.state;
            if (state == State.OPEN) {
                this.state = State.CLOSING;
                this.lock.notifyAll();
                return true;
            }
        }
        return false;
    }

    protected Channel openChannel(Connection connection, String serviceType, OptionMap options) throws IOException {
        IoFuture<Channel> futureChannel = connection.openChannel(serviceType, options);
        return futureChannel.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setChannel(Channel newChannel) {
        if (newChannel == null) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.state != State.OPEN || this.channel != null) {
                return false;
            }
            this.channel = newChannel;
            this.channel.addCloseHandler(new CloseHandler<Channel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleClose(Channel closed, IOException exception) {
                    Object object = FutureManagementChannel.this.lock;
                    synchronized (object) {
                        if (FutureManagementChannel.this.channel == closed) {
                            FutureManagementChannel.this.channel = null;
                        }
                        FutureManagementChannel.this.lock.notifyAll();
                    }
                }
            });
            this.lock.notifyAll();
            return true;
        }
    }

    static class Establishing
    extends FutureManagementChannel {
        private final String serviceType;
        private final OptionMap channelOptions;
        private final Channel.Receiver receiver;
        private final ProtocolConnectionManager connectionManager;

        Establishing(String serviceType, Channel.Receiver receiver, ProtocolConnectionConfiguration configuration) {
            this.serviceType = serviceType;
            this.receiver = receiver;
            this.channelOptions = configuration.getOptionMap();
            this.connectionManager = ProtocolConnectionManager.create(configuration, (ProtocolConnectionManager.ConnectionOpenHandler)this);
        }

        @Override
        public Channel getChannel() throws IOException {
            Channel channel = super.getChannel();
            if (channel != null) {
                return channel;
            }
            this.connectionManager.connect();
            channel = super.getChannel();
            if (channel == null) {
                throw ProtocolLogger.ROOT_LOGGER.channelClosed();
            }
            return channel;
        }

        @Override
        public void connectionOpened(Connection connection) throws IOException {
            Channel channel = this.openChannel(connection, this.serviceType, this.channelOptions);
            if (this.setChannel(channel)) {
                channel.receiveMessage(this.receiver);
            } else {
                channel.closeAsync();
            }
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.connectionManager.shutdown();
            }
        }
    }

    public static enum State {
        OPEN,
        CLOSING,
        CLOSED;

    }
}

