/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.protocol.mgmt;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.shaded.jboss.as.protocol.StreamUtils;
import org.shaded.jboss.as.protocol.logging.ProtocolLogger;
import org.shaded.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.shaded.jboss.as.protocol.mgmt.FlushableDataOutputImpl;
import org.shaded.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.shaded.jboss.as.protocol.mgmt.ManagementPongHeader;
import org.shaded.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.shaded.jboss.remoting3.Channel;
import org.shaded.jboss.remoting3.MessageInputStream;
import org.shaded.jboss.remoting3.MessageOutputStream;

public abstract class ManagementChannelReceiver
implements ManagementMessageHandler,
Channel.Receiver {
    private volatile long lastMessageTime;

    public static ManagementChannelReceiver createDelegating(final ManagementMessageHandler handler) {
        assert (handler != null);
        return new ManagementChannelReceiver(){

            @Override
            public void handleMessage(Channel channel, DataInput input, ManagementProtocolHeader header) throws IOException {
                handler.handleMessage(channel, input, header);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Channel channel, MessageInputStream message) {
        try {
            ProtocolLogger.ROOT_LOGGER.tracef("%s handling incoming data", (Object)this);
            this.lastMessageTime = System.currentTimeMillis();
            DataInputStream input = new DataInputStream(message);
            ManagementProtocolHeader header = ManagementProtocolHeader.parse(input);
            byte type = header.getType();
            try {
                if (type == 5) {
                    ProtocolLogger.ROOT_LOGGER.tracef("Received ping on %s", (Object)this);
                    ManagementChannelReceiver.handlePing(channel, header);
                } else if (type == 6) {
                    ProtocolLogger.ROOT_LOGGER.tracef("Received on on %s", (Object)this);
                } else if (type == 4) {
                    ProtocolLogger.ROOT_LOGGER.tracef("Received bye bye on %s, closing", (Object)this);
                    this.handleChannelReset(channel);
                } else {
                    this.handleMessage(channel, input, header);
                }
            }
            finally {
                try {
                    while (message.read() != -1) {
                    }
                }
                catch (IOException iOException) {}
            }
            message.close();
        }
        catch (IOException e) {
            this.handleError(channel, e);
        }
        catch (Exception e) {
            this.handleError(channel, new IOException(e));
        }
        finally {
            StreamUtils.safeClose(message);
            ProtocolLogger.ROOT_LOGGER.tracef("%s done handling incoming data", (Object)this);
        }
        Channel.Receiver next = this.next();
        if (next != null) {
            channel.receiveMessage(next);
        }
    }

    public long getLastMessageTime() {
        return this.lastMessageTime;
    }

    protected Channel.Receiver next() {
        return this;
    }

    @Override
    public void handleError(Channel channel, IOException error) {
        ProtocolLogger.ROOT_LOGGER.tracef((Throwable)error, "%s error handling incoming data", (Object)this);
        try {
            channel.close();
        }
        catch (IOException e) {
            ProtocolLogger.ROOT_LOGGER.errorClosingChannel(e.getMessage());
        }
    }

    @Override
    public void handleEnd(Channel channel) {
        try {
            channel.close();
        }
        catch (IOException e) {
            ProtocolLogger.ROOT_LOGGER.errorClosingChannel(e.getMessage());
        }
    }

    protected void handleChannelReset(Channel channel) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void shutdownNow() {
    }

    @Override
    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void handlePing(Channel channel, ManagementProtocolHeader header) throws IOException {
        ManagementPongHeader response = new ManagementPongHeader(header.getVersion());
        MessageOutputStream output = channel.writeMessage();
        try {
            ManagementChannelReceiver.writeHeader(response, output);
            output.close();
        }
        finally {
            StreamUtils.safeClose(output);
        }
    }

    protected static void writeHeader(ManagementProtocolHeader header, OutputStream os) throws IOException {
        FlushableDataOutput output = FlushableDataOutputImpl.create(os);
        header.write(output);
    }
}

