/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.dmr;

import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.shaded.jboss.dmr.ModelType;
import org.shaded.jboss.dmr.ModelValue;
import org.shaded.jboss.dmr.ValueExpression;

final class BooleanModelValue
extends ModelValue {
    private final boolean value;
    static final BooleanModelValue TRUE = new BooleanModelValue(true);
    static final BooleanModelValue FALSE = new BooleanModelValue(false);
    private static final byte[] TRUE_BYTES = new byte[]{1};
    private static final byte[] FALSE_BYTES = new byte[]{0};

    private BooleanModelValue(boolean value) {
        super(ModelType.BOOLEAN);
        this.value = value;
    }

    @Override
    void writeExternal(DataOutput out) throws IOException {
        out.write(ModelType.BOOLEAN.typeChar);
        out.writeBoolean(this.value);
    }

    @Override
    long asLong() {
        return this.value ? 1L : 0L;
    }

    @Override
    long asLong(long defVal) {
        return this.value ? 1L : 0L;
    }

    @Override
    int asInt() {
        return this.value ? 1 : 0;
    }

    @Override
    int asInt(int defVal) {
        return this.value ? 1 : 0;
    }

    @Override
    boolean asBoolean() {
        return this.value;
    }

    @Override
    boolean asBoolean(boolean defVal) {
        return this.value;
    }

    @Override
    double asDouble() {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    double asDouble(double defVal) {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    byte[] asBytes() {
        return this.value ? (byte[])TRUE_BYTES.clone() : (byte[])FALSE_BYTES.clone();
    }

    @Override
    BigDecimal asBigDecimal() {
        return this.value ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    BigInteger asBigInteger() {
        return this.value ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    String asString() {
        return Boolean.toString(this.value);
    }

    @Override
    ValueExpression asExpression() {
        return new ValueExpression(this.asString());
    }

    static BooleanModelValue valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public boolean equals(Object other) {
        return other == this;
    }

    @Override
    public int hashCode() {
        return Boolean.valueOf(this.value).hashCode();
    }
}

