/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.dmr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.shaded.jboss.dmr.ValueExpressionResolver;

public final class ValueExpression
implements Externalizable {
    private static final long serialVersionUID = -277358532170444708L;
    private static final Field expressionStringField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            Field field;
            try {
                field = ValueExpression.class.getDeclaredField("expressionString");
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldError(e.getMessage());
            }
            field.setAccessible(true);
            return field;
        }
    });
    private final String expressionString;

    public static String quote(String string) {
        return string.replace("$", "$$");
    }

    public ValueExpression(String expressionString) {
        if (expressionString == null) {
            throw new IllegalArgumentException("expressionString is null");
        }
        this.expressionString = expressionString;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.expressionString);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        String str = in.readUTF();
        try {
            expressionStringField.set(this, str);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getExpressionString() {
        return this.expressionString;
    }

    public int hashCode() {
        return this.expressionString.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ValueExpression && this.equals((ValueExpression)other);
    }

    public boolean equals(ValueExpression other) {
        return this == other || other != null && this.expressionString.equals(other.expressionString);
    }

    public String resolveString() {
        return this.resolveString(ValueExpressionResolver.DEFAULT_RESOLVER);
    }

    public String resolveString(ValueExpressionResolver resolver) {
        return resolver.resolve(this);
    }

    public boolean resolveBoolean() {
        String value = this.resolveString();
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException();
    }

    public boolean resolveBoolean(ValueExpressionResolver resolver) {
        String value = this.resolveString(resolver);
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException();
    }

    public int resolveInt() {
        return Integer.parseInt(this.resolveString());
    }

    public int resolveInt(ValueExpressionResolver resolver) {
        return Integer.parseInt(this.resolveString(resolver));
    }

    public long resolveLong() {
        return Long.parseLong(this.resolveString());
    }

    public long resolveLong(ValueExpressionResolver resolver) {
        return Long.parseLong(this.resolveString(resolver));
    }

    public BigInteger resolveBigInteger() {
        return new BigInteger(this.resolveString());
    }

    public BigInteger resolveBigInteger(ValueExpressionResolver resolver) {
        return new BigInteger(this.resolveString(resolver));
    }

    public BigDecimal resolveBigDecimal() {
        return new BigDecimal(this.resolveString());
    }

    public BigDecimal resolveBigDecimal(ValueExpressionResolver resolver) {
        return new BigDecimal(this.resolveString(resolver));
    }

    public String toString() {
        return "Expression \"" + this.expressionString + "\"";
    }
}

