/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.modules;

import java.util.Collections;
import java.util.List;
import org.shaded.jboss.modules.LocalLoader;
import org.shaded.jboss.modules.Resource;
import org.shaded.jboss.modules.filter.ClassFilter;
import org.shaded.jboss.modules.filter.PathFilter;

class FilteredLocalLoader
implements LocalLoader {
    private final ClassFilter classFilter;
    private final LocalLoader originalLoader;
    private final PathFilter resourcePathFilter;

    FilteredLocalLoader(ClassFilter classFilter, PathFilter resourcePathFilter, LocalLoader originalLoader) {
        this.classFilter = classFilter;
        this.originalLoader = originalLoader;
        this.resourcePathFilter = resourcePathFilter;
    }

    @Override
    public Class<?> loadClassLocal(String name, boolean resolve) {
        return this.classFilter.accept(name) ? this.originalLoader.loadClassLocal(name, resolve) : null;
    }

    @Override
    public Package loadPackageLocal(String name) {
        return this.originalLoader.loadPackageLocal(name);
    }

    @Override
    public List<Resource> loadResourceLocal(String name) {
        return this.resourcePathFilter.accept(name) ? this.originalLoader.loadResourceLocal(name) : Collections.emptyList();
    }
}

