/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.modules;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import org.shaded.jboss.modules.ClassSpec;
import org.shaded.jboss.modules.PackageSpec;
import org.shaded.jboss.modules.PathUtils;
import org.shaded.jboss.modules.Resource;
import org.shaded.jboss.modules.ResourceLoader;
import org.shaded.jboss.modules.filter.PathFilter;

final class FilteredResourceLoader
implements ResourceLoader {
    private final PathFilter filter;
    private final ResourceLoader loader;

    FilteredResourceLoader(PathFilter filter, ResourceLoader loader) {
        this.filter = filter;
        this.loader = loader;
    }

    @Override
    public String getRootName() {
        return this.loader.getRootName();
    }

    @Override
    public ClassSpec getClassSpec(String fileName) throws IOException {
        String canonicalFileName = PathUtils.canonicalize(PathUtils.relativize(fileName));
        return this.filter.accept(canonicalFileName) ? this.loader.getClassSpec(canonicalFileName) : null;
    }

    @Override
    public PackageSpec getPackageSpec(String name) throws IOException {
        return this.loader.getPackageSpec(PathUtils.canonicalize(PathUtils.relativize(name)));
    }

    @Override
    public Resource getResource(String name) {
        String canonicalFileName = PathUtils.canonicalize(PathUtils.relativize(name));
        return this.filter.accept(canonicalFileName) ? this.loader.getResource(canonicalFileName) : null;
    }

    @Override
    public String getLibrary(String name) {
        return this.loader.getLibrary(PathUtils.canonicalize(PathUtils.relativize(name)));
    }

    @Override
    public Collection<String> getPaths() {
        return this.loader.getPaths();
    }

    @Override
    public void close() {
        this.loader.close();
    }

    @Override
    public URI getLocation() {
        return this.loader.getLocation();
    }
}

