/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.modules;

import java.io.File;
import org.shaded.jboss.modules.ModuleIdentifier;

class ModuleXmlUtil {
    public static final String DEFAULT_FILENAME = "module.xml";

    private ModuleXmlUtil() {
    }

    public static File toFile(File dir, ModuleIdentifier identifier) {
        return ModuleXmlUtil.toFile(dir, DEFAULT_FILENAME, identifier);
    }

    public static File toFile(File dir, String name, ModuleIdentifier identifier) {
        if (dir == null || !dir.isDirectory()) {
            throw new IllegalArgumentException(String.format("Must be a directory. File %s is not a directory.", dir));
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The name cannot be empty.");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("The module identifier cannot be null.");
        }
        return new File(dir, ModuleXmlUtil.baseFilename(name, identifier));
    }

    public static String baseDirectory(ModuleIdentifier identifier, String separator) {
        if (identifier == null) {
            throw new IllegalArgumentException("The module identifier cannot be null.");
        }
        String namePath = identifier.getName().replace('.', File.separatorChar);
        StringBuilder baseName = new StringBuilder();
        baseName.append(namePath).append(separator == null ? "" : separator).append(identifier.getSlot()).append(separator == null ? "" : separator);
        return baseName.toString();
    }

    public static String baseDirectory(ModuleIdentifier identifier) {
        return ModuleXmlUtil.baseDirectory(identifier, File.separator);
    }

    public static String baseFilename(ModuleIdentifier identifier) {
        return ModuleXmlUtil.baseFilename(DEFAULT_FILENAME, identifier);
    }

    public static String baseFilename(String name, ModuleIdentifier identifier) {
        return ModuleXmlUtil.baseDirectory(identifier) + name;
    }

    public static String baseFilename(String name, String separator, ModuleIdentifier identifier) {
        return ModuleXmlUtil.baseDirectory(identifier, separator) + name;
    }
}

