/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.modules.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Enumeration;
import org.shaded.jboss.modules.security.PermissionFactory;

public final class FactoryPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = -2524371701490830970L;
    private final PermissionFactory[] factories;
    private volatile Permissions assembled;

    public FactoryPermissionCollection(PermissionFactory ... factories) {
        this.factories = (PermissionFactory[])factories.clone();
        this.setReadOnly();
    }

    @Override
    public void add(Permission permission) {
        throw new SecurityException("Read-only permission collection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Permissions getAssembled() {
        if (this.assembled == null) {
            FactoryPermissionCollection factoryPermissionCollection = this;
            synchronized (factoryPermissionCollection) {
                if (this.assembled == null) {
                    Permissions assembled = new Permissions();
                    for (PermissionFactory factory : this.factories) {
                        Permission permission;
                        if (factory == null || (permission = factory.construct()) == null) continue;
                        assembled.add(permission);
                    }
                    assembled.setReadOnly();
                    this.assembled = assembled;
                }
            }
        }
        return this.assembled;
    }

    @Override
    public boolean implies(Permission permission) {
        return this.getAssembled().implies(permission);
    }

    @Override
    public Enumeration<Permission> elements() {
        return this.getAssembled().elements();
    }

    Object writeReplace() {
        return this.getAssembled();
    }
}

