/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.msc.inject;

import org.shaded.jboss.msc.inject.InjectionException;
import org.shaded.jboss.msc.inject.Injector;

public final class CastingInjector<T>
implements Injector<Object> {
    private final Injector<T> target;
    private final Class<T> type;

    public CastingInjector(Injector<T> target, Class<T> type) {
        this.target = target;
        this.type = type;
    }

    @Override
    public void inject(Object value) throws InjectionException {
        T castValue;
        try {
            castValue = this.type.cast(value);
        }
        catch (ClassCastException e) {
            throw new InjectionException("Injecting the wrong type (expected " + this.type + ", got " + value.getClass() + ")", e);
        }
        this.target.inject(castValue);
    }

    @Override
    public void uninject() {
        this.target.uninject();
    }
}

