/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.msc.inject;

import java.util.concurrent.ConcurrentMap;
import org.shaded.jboss.msc.inject.InjectionException;
import org.shaded.jboss.msc.inject.Injector;
import org.shaded.jboss.msc.inject.RetainingInjector;
import org.shaded.jboss.msc.value.Value;

public final class ConcurrentMapInjector<K, T>
extends RetainingInjector<T>
implements Injector<T> {
    private final ConcurrentMap<K, T> map;
    private final K key;

    public ConcurrentMapInjector(ConcurrentMap<K, T> map, K key) {
        this.map = map;
        this.key = key;
    }

    @Override
    public void inject(T value) throws InjectionException {
        if (this.map.putIfAbsent(this.key, value) != null) {
            throw new InjectionException("Value already injected into map key " + this.key);
        }
        super.inject(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninject() {
        try {
            Value storedValue = this.getStoredValue();
            if (storedValue != null) {
                this.map.remove(this.key, storedValue.getValue());
            }
        }
        finally {
            super.uninject();
        }
    }
}

