/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.msc.service;

import java.util.Collection;
import java.util.HashSet;
import org.shaded.jboss.msc.service.BatchServiceTarget;
import org.shaded.jboss.msc.service.Service;
import org.shaded.jboss.msc.service.ServiceBuilder;
import org.shaded.jboss.msc.service.ServiceBuilderImpl;
import org.shaded.jboss.msc.service.ServiceController;
import org.shaded.jboss.msc.service.ServiceListener;
import org.shaded.jboss.msc.service.ServiceName;
import org.shaded.jboss.msc.service.ServiceRegistryException;
import org.shaded.jboss.msc.service.ServiceTargetImpl;
import org.shaded.jboss.msc.service.StabilityMonitor;
import org.shaded.jboss.msc.value.ImmediateValue;

class BatchServiceTargetImpl
extends ServiceTargetImpl
implements BatchServiceTarget {
    private final Collection<ServiceController<?>> addedServiceControllers = new HashSet();

    BatchServiceTargetImpl(ServiceTargetImpl parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServices() {
        Collection<ServiceController<?>> controllers;
        Collection<ServiceController<?>> collection = controllers = this.addedServiceControllers;
        synchronized (collection) {
            for (ServiceController<?> serviceController : controllers) {
                if (serviceController == null) continue;
                serviceController.setMode(ServiceController.Mode.REMOVE);
            }
            controllers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> ServiceController<T> install(ServiceBuilderImpl<T> serviceBuilder) throws ServiceRegistryException {
        Collection<ServiceController<?>> controllers;
        ServiceController<T> controller = super.install(serviceBuilder);
        Collection<ServiceController<?>> collection = controllers = this.addedServiceControllers;
        synchronized (collection) {
            controllers.add(controller);
        }
        return controller;
    }

    @Override
    public <T> ServiceBuilder<T> addService(ServiceName name, Service<T> service) {
        return this.addServiceValue(name, new ImmediateValue<Service<T>>(service));
    }

    @Override
    public BatchServiceTarget addMonitor(StabilityMonitor monitor) {
        super.addMonitor(monitor);
        return this;
    }

    @Override
    public BatchServiceTarget addMonitors(StabilityMonitor ... monitors) {
        super.addMonitors(monitors);
        return this;
    }

    @Override
    public BatchServiceTarget removeMonitor(StabilityMonitor monitor) {
        super.removeMonitor(monitor);
        return this;
    }

    @Override
    public BatchServiceTarget addListener(ServiceListener<Object> listener) {
        super.addListener(listener);
        return this;
    }

    @Override
    public BatchServiceTarget addListener(ServiceListener<Object> ... listeners) {
        super.addListener(listeners);
        return this;
    }

    @Override
    public BatchServiceTarget addListener(Collection<ServiceListener<Object>> listeners) {
        super.addListener(listeners);
        return this;
    }

    @Override
    public BatchServiceTarget removeListener(ServiceListener<Object> listener) {
        super.removeListener(listener);
        return this;
    }

    @Override
    public BatchServiceTarget addDependency(ServiceName dependency) {
        super.addDependency(dependency);
        return this;
    }

    @Override
    public BatchServiceTarget addDependency(ServiceName ... dependencies) {
        super.addDependency(dependencies);
        return this;
    }

    @Override
    public BatchServiceTarget addDependency(Collection<ServiceName> dependencies) {
        super.addDependency(dependencies);
        return this;
    }

    @Override
    public BatchServiceTarget removeDependency(ServiceName dependency) {
        super.removeDependency(dependency);
        return this;
    }
}

