/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.msc.service;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.shaded.jboss.msc.service.ServiceName;
import org.shaded.jboss.msc.service.UnlockedReadHashMap;

public final class ServiceNameMapper<V> {
    public static final Object ANY = new Object();
    private final Node<V> root = new Node();

    public void registerMatcher(V value, Object ... segments) {
        this.doRegisterMatcher(segments, 0, value, this.root);
    }

    private void doRegisterMatcher(Object[] segments, int idx, V value, Node<V> current) {
        if (segments.length == idx) {
            if (!Node.valueUpdater.compareAndSet(current, null, value)) {
                throw new IllegalArgumentException("Matcher already registered");
            }
            return;
        }
        this.doRegisterMatcher(segments, idx + 1, value, current.getOrCreateChild(segments[idx]));
    }

    public V match(ServiceName serviceName) {
        return this.match(serviceName.toArray(), 0, this.root);
    }

    private V match(String[] segments, int idx, Node<V> current) {
        V result;
        if (segments.length == idx) {
            return (V)((Node)current).value;
        }
        String segment = segments[idx];
        Node childNode = (Node)((Node)current).childMap.get(segment);
        if (childNode != null && (result = this.match(segments, idx + 1, childNode)) != null) {
            return result;
        }
        childNode = (Node)((Node)current).childMap.get(ANY);
        if (childNode != null) {
            return this.match(segments, idx + 1, childNode);
        }
        return null;
    }

    static final class Node<V> {
        private static final AtomicReferenceFieldUpdater<Node, Object> valueUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Object.class, "value");
        private final ConcurrentMap<Object, Node<V>> childMap = new UnlockedReadHashMap<Object, Node<V>>();
        private volatile V value;

        Node() {
        }

        Node<V> getOrCreateChild(Object key) {
            Node<V> appearing;
            Node<V> child;
            if (key == null) {
                throw new IllegalArgumentException("Null segment encountered");
            }
            if (key != ANY) {
                key = key.toString();
            }
            if ((child = (Node<V>)this.childMap.get(key)) == null && (appearing = this.childMap.putIfAbsent(key, child = new Node<V>())) != null) {
                child = appearing;
            }
            return child;
        }
    }
}

