/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.remoting3;

import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import javax.net.ssl.SSLSession;
import org.shaded.jboss.remoting3.Attachments;
import org.shaded.jboss.remoting3.Channel;
import org.shaded.jboss.remoting3.CloseHandler;
import org.shaded.jboss.remoting3.Connection;
import org.shaded.jboss.remoting3.Endpoint;
import org.shaded.jboss.remoting3.EndpointImpl;
import org.shaded.jboss.remoting3.security.UserInfo;
import org.shaded.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.shaded.jboss.remoting3.spi.ConnectionHandler;
import org.shaded.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.shaded.jboss.remoting3.spi.ConnectionProviderContext;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

class ConnectionImpl
extends AbstractHandleableCloseable<Connection>
implements Connection {
    private final Attachments attachments = new Attachments();
    private final ConnectionHandler connectionHandler;
    private final Endpoint endpoint;

    ConnectionImpl(EndpointImpl endpoint, ConnectionHandlerFactory connectionHandlerFactory, ConnectionProviderContext connectionProviderContext) {
        super(endpoint.getExecutor(), true);
        this.endpoint = endpoint;
        EndpointImpl endpointImpl = endpoint;
        endpointImpl.getClass();
        this.connectionHandler = connectionHandlerFactory.createInstance(new EndpointImpl.LocalConnectionContext(endpointImpl, connectionProviderContext, this));
    }

    @Override
    protected void closeAction() throws IOException {
        this.connectionHandler.closeAsync();
        this.connectionHandler.addCloseHandler(new CloseHandler<ConnectionHandler>(){

            @Override
            public void handleClose(ConnectionHandler closed, IOException exception) {
                ConnectionImpl.this.closeComplete();
            }
        });
    }

    ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    @Override
    public Collection<Principal> getPrincipals() {
        return this.connectionHandler.getPrincipals();
    }

    @Override
    public UserInfo getUserInfo() {
        return this.connectionHandler.getUserInfo();
    }

    @Override
    public SSLSession getSslSession() {
        return this.connectionHandler.getSslSession();
    }

    @Override
    public IoFuture<Channel> openChannel(String serviceType, OptionMap optionMap) {
        FutureResult<Channel> result = new FutureResult<Channel>(this.getExecutor());
        result.addCancelHandler(this.connectionHandler.open(serviceType, result, optionMap));
        return result.getIoFuture();
    }

    @Override
    public String getRemoteEndpointName() {
        return this.connectionHandler.getRemoteEndpointName();
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    public String toString() {
        return String.format("Remoting connection <%x>", this.hashCode());
    }
}

