/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.remoting3;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.shaded.jboss.remoting3.Endpoint;
import org.shaded.jboss.remoting3.EndpointImpl;
import org.shaded.jboss.remoting3.security.RemotingPermission;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public final class Remoting {
    private static final RemotingPermission CREATE_ENDPOINT_PERM = new RemotingPermission("createEndpoint");

    public static Endpoint createEndpoint(String endpointName, XnioWorker xnioWorker, OptionMap optionMap) throws IOException {
        if (endpointName == null) {
            throw new IllegalArgumentException("endpointName is null");
        }
        if (optionMap == null) {
            throw new IllegalArgumentException("optionMap is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_ENDPOINT_PERM);
        }
        return EndpointImpl.construct(xnioWorker, false, endpointName, optionMap);
    }

    public static Endpoint createEndpoint(String endpointName, Xnio xnio, OptionMap optionMap) throws IOException {
        if (endpointName == null) {
            throw new IllegalArgumentException("endpointName is null");
        }
        if (optionMap == null) {
            throw new IllegalArgumentException("optionMap is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_ENDPOINT_PERM);
        }
        OptionMap modifiedOptionMap = OptionMap.builder().addAll(optionMap).set(Options.WORKER_NAME, endpointName == null ? "Remoting (anonymous)" : "Remoting \"" + endpointName + "\"").getMap();
        final AtomicReference<EndpointImpl> endpointRef = new AtomicReference<EndpointImpl>();
        XnioWorker xnioWorker = xnio.createWorker(null, modifiedOptionMap, new Runnable(){

            @Override
            public void run() {
                EndpointImpl endpoint = endpointRef.getAndSet(null);
                if (endpoint != null) {
                    endpoint.closeComplete();
                }
            }
        });
        EndpointImpl endpoint = EndpointImpl.construct(xnioWorker, true, endpointName, optionMap);
        endpointRef.set(endpoint);
        return endpoint;
    }

    public static Endpoint createEndpoint(String endpointName, OptionMap optionMap) throws IOException {
        return Remoting.createEndpoint(endpointName, Xnio.getInstance(), optionMap);
    }

    public static Endpoint createEndpoint(OptionMap optionMap) throws IOException {
        return Remoting.createEndpoint(null, optionMap);
    }

    public static Endpoint createEndpoint() throws IOException {
        return Remoting.createEndpoint(null, OptionMap.EMPTY);
    }

    private Remoting() {
    }
}

