/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.remoting3.security;

import java.io.IOException;
import java.security.KeyPair;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.shaded.jboss.remoting3.security.AuthorizingCallbackHandler;
import org.shaded.jboss.remoting3.security.RemotingPermission;
import org.shaded.jboss.remoting3.security.ServerAuthenticationProvider;
import org.shaded.jboss.remoting3.security.SimpleUserInfo;
import org.shaded.jboss.remoting3.security.UserInfo;

public final class SimpleServerAuthenticationProvider
implements ServerAuthenticationProvider {
    private static final RemotingPermission ADD_USER_PERM = new RemotingPermission("addServerUser");
    private final Map<String, Map<String, Entry>> map = new HashMap<String, Map<String, Entry>>();

    @Override
    public AuthorizingCallbackHandler getCallbackHandler(String mechanismName) {
        return new AuthorizingCallbackHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                String userName = null;
                String realmName = null;
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback;
                        String defaultName = nameCallback.getDefaultName();
                        userName = defaultName.toLowerCase().trim();
                        nameCallback.setName(userName);
                        continue;
                    }
                    if (callback instanceof RealmCallback) {
                        RealmCallback realmCallback = (RealmCallback)callback;
                        String defaultRealm = realmCallback.getDefaultText();
                        if (defaultRealm == null) continue;
                        realmName = defaultRealm.toLowerCase().trim();
                        realmCallback.setText(realmName);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        Map map;
                        PasswordCallback passwordCallback = (PasswordCallback)callback;
                        Entry entry = null;
                        if (realmName == null) {
                            map = SimpleServerAuthenticationProvider.this.map;
                            synchronized (map) {
                                for (Map realmMap : SimpleServerAuthenticationProvider.this.map.values()) {
                                    if (!realmMap.containsKey(userName)) continue;
                                    entry = (Entry)realmMap.get(userName);
                                    break;
                                }
                            }
                        }
                        map = SimpleServerAuthenticationProvider.this.map;
                        synchronized (map) {
                            Map realmMap = (Map)SimpleServerAuthenticationProvider.this.map.get(realmName);
                            if (realmMap != null) {
                                entry = (Entry)realmMap.get(userName);
                            }
                        }
                        if (entry == null) {
                            throw new AuthenticationException("No matching user found");
                        }
                        passwordCallback.setPassword(entry.getPassword());
                        continue;
                    }
                    if (callback instanceof AuthorizeCallback) {
                        AuthorizeCallback authorizeCallback = (AuthorizeCallback)callback;
                        authorizeCallback.setAuthorized(authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizationID()));
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback, "Callback not supported: " + callback);
                }
            }

            @Override
            public UserInfo createUserInfo(Collection<Principal> remotingPrincipals) {
                return new SimpleUserInfo(remotingPrincipals);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(String userName, String userRealm, char[] password, KeyPair ... keyPairs) {
        if (userName == null) {
            throw new IllegalArgumentException("userName is null");
        }
        if (userRealm == null) {
            throw new IllegalArgumentException("userRealm is null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is null");
        }
        if (keyPairs == null) {
            throw new IllegalArgumentException("keyPairs is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_USER_PERM);
        }
        String canonUserRealm = userRealm.toLowerCase().trim();
        String canonUserName = userName.toLowerCase().trim();
        Map<String, Map<String, Entry>> map = this.map;
        synchronized (map) {
            Map<String, Entry> realmMap = this.map.get(canonUserRealm);
            if (realmMap == null) {
                realmMap = new HashMap<String, Entry>();
                this.map.put(canonUserRealm, realmMap);
            }
            realmMap.put(canonUserName, new Entry(canonUserName, canonUserRealm, password, keyPairs));
        }
    }

    private static final class Entry {
        private final String userName;
        private final String userRealm;
        private final char[] password;
        private final KeyPair[] keyPairs;

        private Entry(String userName, String userRealm, char[] password, KeyPair[] keyPairs) {
            this.userName = userName;
            this.userRealm = userRealm;
            this.password = password;
            this.keyPairs = keyPairs;
        }

        String getUserName() {
            return this.userName;
        }

        String getUserRealm() {
            return this.userRealm;
        }

        char[] getPassword() {
            return this.password;
        }

        KeyPair[] getKeyPairs() {
            return this.keyPairs;
        }
    }
}

