/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.threads;

import org.jboss.logging.Logger;
import org.shaded.jboss.threads.DirectExecutor;

class ExceptionLoggingExecutor
implements DirectExecutor {
    private final DirectExecutor delegate;
    private final Logger log;
    private final Logger.Level level;

    ExceptionLoggingExecutor(DirectExecutor delegate, Logger log, Logger.Level level) {
        this.delegate = delegate;
        this.log = log;
        this.level = level;
    }

    ExceptionLoggingExecutor(DirectExecutor delegate, Logger log) {
        this(delegate, log, Logger.Level.ERROR);
    }

    @Override
    public void execute(Runnable command) {
        try {
            this.delegate.execute(command);
        }
        catch (Throwable t) {
            this.log.logf(this.level, t, "Exception thrown from thread task", new Object[0]);
        }
    }

    public String toString() {
        return String.format("%s to \"%s\" -> %s", super.toString(), this.log.getName(), this.delegate);
    }
}

