/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.threads;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.shaded.jboss.threads.BlockingExecutor;
import org.shaded.jboss.threads.DirectExecutor;
import org.shaded.jboss.threads.ExecutionInterruptedException;
import org.shaded.jboss.threads.ExecutionTimedOutException;
import org.shaded.jboss.threads.ThreadCreationException;
import org.shaded.jboss.threads.management.BoundedThreadPoolExecutorMBean;

class ThreadFactoryExecutor
implements BlockingExecutor,
BoundedThreadPoolExecutorMBean {
    private final ThreadFactory factory;
    private final Semaphore limitSemaphore;
    private final DirectExecutor taskExecutor;
    private final Object lock = new Object();
    private int maxThreads;
    private int largestThreadCount;
    private int currentThreadCount;
    private final AtomicInteger rejected = new AtomicInteger();
    private volatile boolean blocking;

    ThreadFactoryExecutor(ThreadFactory factory, int maxThreads, boolean blocking, DirectExecutor taskExecutor) {
        this.factory = factory;
        this.maxThreads = maxThreads;
        this.blocking = blocking;
        this.taskExecutor = taskExecutor;
        this.limitSemaphore = new Semaphore(maxThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxThreads() {
        Object object = this.lock;
        synchronized (object) {
            return this.maxThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxThreads(int maxThreads) {
        if (maxThreads < 0) {
            throw new IllegalArgumentException("Max threads must not be negative");
        }
        Object object = this.lock;
        synchronized (object) {
            int old = this.maxThreads;
            int diff = old - maxThreads;
            if (diff < 0) {
                this.limitSemaphore.release(-diff);
            } else if (diff > 0 && !this.limitSemaphore.tryAcquire(diff)) {
                throw new IllegalArgumentException("Cannot reduce maximum threads below current number of running threads");
            }
            this.maxThreads = maxThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final Runnable task) {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        try {
            Semaphore semaphore = this.limitSemaphore;
            if (this.blocking) {
                try {
                    semaphore.acquire();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ExecutionInterruptedException();
                }
            } else if (!semaphore.tryAcquire()) {
                throw new RejectedExecutionException("Task limit reached");
            }
            boolean ok = false;
            try {
                Thread thread = this.factory.newThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Object object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                int t = ++ThreadFactoryExecutor.this.currentThreadCount;
                                if (t > ThreadFactoryExecutor.this.largestThreadCount) {
                                    ThreadFactoryExecutor.this.largestThreadCount = t;
                                }
                            }
                            ThreadFactoryExecutor.this.taskExecutor.execute(task);
                            object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                ThreadFactoryExecutor.this.currentThreadCount--;
                            }
                        }
                        finally {
                            ThreadFactoryExecutor.this.limitSemaphore.release();
                        }
                    }
                });
                if (thread == null) {
                    throw new ThreadCreationException("No threads can be created");
                }
                thread.start();
                ok = true;
            }
            finally {
                if (!ok) {
                    semaphore.release();
                }
            }
        }
        catch (RejectedExecutionException e) {
            this.rejected.getAndIncrement();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBlocking(final Runnable task) throws RejectedExecutionException, InterruptedException {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        try {
            Semaphore semaphore = this.limitSemaphore;
            semaphore.acquire();
            boolean ok = false;
            try {
                Thread thread = this.factory.newThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Object object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                int t = ++ThreadFactoryExecutor.this.currentThreadCount;
                                if (t > ThreadFactoryExecutor.this.largestThreadCount) {
                                    ThreadFactoryExecutor.this.largestThreadCount = t;
                                }
                            }
                            ThreadFactoryExecutor.this.taskExecutor.execute(task);
                            object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                ThreadFactoryExecutor.this.currentThreadCount--;
                            }
                        }
                        finally {
                            ThreadFactoryExecutor.this.limitSemaphore.release();
                        }
                    }
                });
                if (thread == null) {
                    throw new ThreadCreationException("No threads can be created");
                }
                thread.start();
                ok = true;
            }
            finally {
                if (!ok) {
                    semaphore.release();
                }
            }
        }
        catch (RejectedExecutionException e) {
            this.rejected.getAndIncrement();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBlocking(final Runnable task, long timeout, TimeUnit unit) throws RejectedExecutionException, InterruptedException {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        try {
            Semaphore semaphore = this.limitSemaphore;
            if (!semaphore.tryAcquire(timeout, unit)) {
                throw new ExecutionTimedOutException();
            }
            boolean ok = false;
            try {
                Thread thread = this.factory.newThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Object object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                int t = ++ThreadFactoryExecutor.this.currentThreadCount;
                                if (t > ThreadFactoryExecutor.this.largestThreadCount) {
                                    ThreadFactoryExecutor.this.largestThreadCount = t;
                                }
                            }
                            ThreadFactoryExecutor.this.taskExecutor.execute(task);
                            object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                ThreadFactoryExecutor.this.currentThreadCount--;
                            }
                        }
                        finally {
                            ThreadFactoryExecutor.this.limitSemaphore.release();
                        }
                    }
                });
                if (thread == null) {
                    throw new ThreadCreationException("No threads can be created");
                }
                thread.start();
                ok = true;
            }
            finally {
                if (!ok) {
                    semaphore.release();
                }
            }
        }
        catch (RejectedExecutionException e) {
            this.rejected.getAndIncrement();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeNonBlocking(final Runnable task) throws RejectedExecutionException {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        try {
            Semaphore semaphore = this.limitSemaphore;
            if (!semaphore.tryAcquire()) {
                throw new RejectedExecutionException("Task limit reached");
            }
            boolean ok = false;
            try {
                Thread thread = this.factory.newThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Object object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                int t = ++ThreadFactoryExecutor.this.currentThreadCount;
                                if (t > ThreadFactoryExecutor.this.largestThreadCount) {
                                    ThreadFactoryExecutor.this.largestThreadCount = t;
                                }
                            }
                            ThreadFactoryExecutor.this.taskExecutor.execute(task);
                            object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                ThreadFactoryExecutor.this.currentThreadCount--;
                            }
                        }
                        finally {
                            ThreadFactoryExecutor.this.limitSemaphore.release();
                        }
                    }
                });
                if (thread == null) {
                    throw new ThreadCreationException("No threads can be created");
                }
                thread.start();
                ok = true;
            }
            finally {
                if (!ok) {
                    semaphore.release();
                }
            }
        }
        catch (RejectedExecutionException e) {
            this.rejected.getAndIncrement();
            throw e;
        }
    }

    @Override
    public boolean isBlocking() {
        return this.blocking;
    }

    @Override
    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLargestThreadCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.largestThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentThreadCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentThreadCount;
        }
    }

    @Override
    public int getQueueSize() {
        return 0;
    }

    @Override
    public int getRejectedCount() {
        return this.rejected.get();
    }

    @Override
    public long getKeepAliveTime() {
        return 0L;
    }

    @Override
    public void setKeepAliveTime(long milliseconds) {
        if (milliseconds != 0L) {
            throw new IllegalArgumentException("Keep-alive may only be set to 0ms");
        }
    }

    public String toString() {
        return String.format("%s (%s)", super.toString(), this.factory);
    }
}

