/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.shaded.jgrapht.Graph;
import org.shaded.jgrapht.Graphs;
import org.shaded.jgrapht.event.GraphEdgeChangeEvent;
import org.shaded.jgrapht.event.GraphListener;
import org.shaded.jgrapht.event.GraphVertexChangeEvent;
import org.shaded.jgrapht.util.ModifiableInteger;

public class NeighborIndex<V, E>
implements GraphListener<V, E> {
    Map<V, Neighbors<V, E>> neighborMap = new HashMap<V, Neighbors<V, E>>();
    private Graph<V, E> graph;

    public NeighborIndex(Graph<V, E> g) {
        this.graph = g;
    }

    public Set<V> neighborsOf(V v) {
        return this.getNeighbors(v).getNeighbors();
    }

    public List<V> neighborListOf(V v) {
        return this.getNeighbors(v).getNeighborList();
    }

    @Override
    public void edgeAdded(GraphEdgeChangeEvent<V, E> e) {
        E edge = e.getEdge();
        V source = this.graph.getEdgeSource(edge);
        V target = this.graph.getEdgeTarget(edge);
        if (this.neighborMap.containsKey(source)) {
            this.getNeighbors(source).addNeighbor(target);
        } else {
            this.getNeighbors(source);
        }
        if (this.neighborMap.containsKey(target)) {
            this.getNeighbors(target).addNeighbor(source);
        } else {
            this.getNeighbors(target);
        }
    }

    @Override
    public void edgeRemoved(GraphEdgeChangeEvent<V, E> e) {
        E edge = e.getEdge();
        V source = e.getEdgeSource();
        V target = e.getEdgeTarget();
        if (this.neighborMap.containsKey(source)) {
            this.neighborMap.get(source).removeNeighbor(target);
        }
        if (this.neighborMap.containsKey(target)) {
            this.neighborMap.get(target).removeNeighbor(source);
        }
    }

    @Override
    public void vertexAdded(GraphVertexChangeEvent<V> e) {
    }

    @Override
    public void vertexRemoved(GraphVertexChangeEvent<V> e) {
        this.neighborMap.remove(e.getVertex());
    }

    private Neighbors<V, E> getNeighbors(V v) {
        Neighbors<V, E> neighbors = this.neighborMap.get(v);
        if (neighbors == null) {
            neighbors = new Neighbors(v, Graphs.neighborListOf(this.graph, v));
            this.neighborMap.put((Neighbors<V, E>)v, (Neighbors<Neighbors<V, E>, E>)neighbors);
        }
        return neighbors;
    }

    static class Neighbors<V, E> {
        private Map<V, ModifiableInteger> neighborCounts = new LinkedHashMap<V, ModifiableInteger>();
        private Set<V> neighborSet = Collections.unmodifiableSet(this.neighborCounts.keySet());

        public Neighbors(V v, Collection<V> neighbors) {
            for (V neighbor : neighbors) {
                this.addNeighbor(neighbor);
            }
        }

        public void addNeighbor(V v) {
            ModifiableInteger count = this.neighborCounts.get(v);
            if (count == null) {
                count = new ModifiableInteger(1);
                this.neighborCounts.put((ModifiableInteger)v, count);
            } else {
                count.increment();
            }
        }

        public void removeNeighbor(V v) {
            ModifiableInteger count = this.neighborCounts.get(v);
            if (count == null) {
                throw new IllegalArgumentException("Attempting to remove a neighbor that wasn't present");
            }
            count.decrement();
            if (count.getValue() == 0) {
                this.neighborCounts.remove(v);
            }
        }

        public Set<V> getNeighbors() {
            return this.neighborSet;
        }

        public List<V> getNeighborList() {
            ArrayList<V> neighbors = new ArrayList<V>();
            for (Map.Entry<V, ModifiableInteger> entry : this.neighborCounts.entrySet()) {
                V v = entry.getKey();
                int count = entry.getValue().intValue();
                for (int i = 0; i < count; ++i) {
                    neighbors.add(v);
                }
            }
            return neighbors;
        }
    }
}

