/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jgrapht.experimental.isomorphism;

import org.shaded.jgrapht.Graph;
import org.shaded.jgrapht.experimental.equivalence.EquivalenceComparator;
import org.shaded.jgrapht.experimental.equivalence.EquivalenceComparatorChainBase;
import org.shaded.jgrapht.experimental.isomorphism.EquivalenceIsomorphismInspector;
import org.shaded.jgrapht.experimental.isomorphism.GraphIsomorphismInspector;
import org.shaded.jgrapht.experimental.isomorphism.VertexDegreeEquivalenceComparator;
import org.shaded.jgrapht.graph.DirectedMultigraph;
import org.shaded.jgrapht.graph.Multigraph;
import org.shaded.jgrapht.graph.Pseudograph;

public class AdaptiveIsomorphismInspectorFactory {
    public static final int GRAPH_TYPE_ARBITRARY = 0;
    public static final int GRAPH_TYPE_PLANAR = 1;
    public static final int GRAPH_TYPE_TREE = 2;
    public static final int GRAPH_TYPE_MULTIGRAPH = 3;

    public static <V, E> GraphIsomorphismInspector createIsomorphismInspector(Graph<V, E> graph1, Graph<V, E> graph2, EquivalenceComparator<V, Graph<V, E>> vertexChecker, EquivalenceComparator<E, Graph<V, E>> edgeChecker) {
        int graphType = AdaptiveIsomorphismInspectorFactory.checkGraphsType(graph1, graph2);
        return AdaptiveIsomorphismInspectorFactory.createAppropriateConcreteInspector(graphType, graph1, graph2, vertexChecker, edgeChecker);
    }

    public static <V, E> GraphIsomorphismInspector createIsomorphismInspector(Graph<V, E> graph1, Graph<V, E> graph2) {
        return AdaptiveIsomorphismInspectorFactory.createIsomorphismInspector(graph1, graph2, null, null);
    }

    public static <V, E> GraphIsomorphismInspector createIsomorphismInspectorByType(int type, Graph<V, E> graph1, Graph<V, E> graph2, EquivalenceComparator<V, Graph<V, E>> vertexChecker, EquivalenceComparator<E, Graph<V, E>> edgeChecker) {
        return AdaptiveIsomorphismInspectorFactory.createAppropriateConcreteInspector(type, graph1, graph2, vertexChecker, edgeChecker);
    }

    public static <V, E> GraphIsomorphismInspector createIsomorphismInspectorByType(int type, Graph<V, E> graph1, Graph<V, E> graph2) {
        return AdaptiveIsomorphismInspectorFactory.createAppropriateConcreteInspector(type, graph1, graph2, null, null);
    }

    protected static <V, E> GraphIsomorphismInspector createAppropriateConcreteInspector(int graphType, Graph<V, E> graph1, Graph<V, E> graph2, EquivalenceComparator<V, Graph<V, E>> vertexChecker, EquivalenceComparator<E, Graph<V, E>> edgeChecker) {
        AdaptiveIsomorphismInspectorFactory.assertUnsupportedGraphTypes(graph1);
        AdaptiveIsomorphismInspectorFactory.assertUnsupportedGraphTypes(graph2);
        GraphIsomorphismInspector currentInspector = null;
        switch (graphType) {
            case 0: 
            case 1: 
            case 2: {
                currentInspector = AdaptiveIsomorphismInspectorFactory.createTopologicalExhaustiveInspector(graph1, graph2, vertexChecker, edgeChecker);
                break;
            }
            default: {
                throw new IllegalArgumentException("The type was not one of the supported types.");
            }
        }
        return currentInspector;
    }

    protected static void assertUnsupportedGraphTypes(Graph g) throws IllegalArgumentException {
        if (g instanceof Multigraph || g instanceof DirectedMultigraph || g instanceof Pseudograph) {
            throw new IllegalArgumentException("graph type not supported for the graph" + g);
        }
    }

    protected static int checkGraphsType(Graph graph1, Graph graph2) {
        return 0;
    }

    protected static <V, E> GraphIsomorphismInspector createTopologicalExhaustiveInspector(Graph<V, E> graph1, Graph<V, E> graph2, EquivalenceComparator<V, Graph<V, E>> vertexChecker, EquivalenceComparator<E, Graph<V, E>> edgeChecker) {
        VertexDegreeEquivalenceComparator degreeComparator = new VertexDegreeEquivalenceComparator();
        EquivalenceComparatorChainBase vertexChainedChecker = new EquivalenceComparatorChainBase(degreeComparator);
        vertexChainedChecker.appendComparator(vertexChecker);
        EquivalenceIsomorphismInspector<V, E> inspector = new EquivalenceIsomorphismInspector<V, E>(graph1, graph2, vertexChainedChecker, edgeChecker);
        return inspector;
    }
}

