/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jgrapht.generate;

import java.util.HashMap;
import java.util.Map;
import org.shaded.jgrapht.Graph;
import org.shaded.jgrapht.VertexFactory;
import org.shaded.jgrapht.generate.GraphGenerator;
import org.shaded.jgrapht.generate.LinearGraphGenerator;

public class RingGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private int size;

    public RingGraphGenerator(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.size = size;
    }

    @Override
    public void generateGraph(Graph<V, E> target, VertexFactory<V> vertexFactory, Map<String, V> resultMap) {
        if (this.size < 1) {
            return;
        }
        LinearGraphGenerator linearGenerator = new LinearGraphGenerator(this.size);
        HashMap privateMap = new HashMap();
        linearGenerator.generateGraph(target, vertexFactory, privateMap);
        Object startVertex = privateMap.get("Start Vertex");
        Object endVertex = privateMap.get("End Vertex");
        target.addEdge(endVertex, startVertex);
    }
}

