/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jolokia.client.request;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.shaded.jolokia.client.request.J4pReadRequest;
import org.shaded.jolokia.client.request.J4pResponse;
import org.shaded.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class J4pReadResponse
extends J4pResponse<J4pReadRequest> {
    J4pReadResponse(J4pReadRequest pRequest, JSONObject pJsonResponse) {
        super(pRequest, pJsonResponse);
    }

    public Collection<ObjectName> getObjectNames() throws MalformedObjectNameException {
        ObjectName mBean = ((J4pReadRequest)this.getRequest()).getObjectName();
        if (mBean.isPattern()) {
            JSONObject values = (JSONObject)this.getValue();
            HashSet<ObjectName> ret = new HashSet<ObjectName>();
            for (Object name : values.keySet()) {
                ret.add(new ObjectName((String)name));
            }
            return ret;
        }
        return Arrays.asList(mBean);
    }

    public Collection<String> getAttributes(ObjectName pObjectName) {
        ObjectName requestMBean = ((J4pReadRequest)this.getRequest()).getObjectName();
        if (requestMBean.isPattern()) {
            JSONObject attributes = this.getAttributesForObjectNameWithPatternRequest(pObjectName);
            return attributes.keySet();
        }
        if (pObjectName != null && !pObjectName.equals(requestMBean)) {
            throw new IllegalArgumentException("Given ObjectName " + pObjectName + " doesn't match with" + " the single ObjectName " + requestMBean + " given in the request");
        }
        return this.getAttributes();
    }

    public Collection<String> getAttributes() {
        J4pReadRequest request = (J4pReadRequest)this.getRequest();
        ObjectName requestBean = request.getObjectName();
        if (requestBean.isPattern()) {
            throw new IllegalArgumentException("Attributes can be fetched only for non-pattern request (current: " + requestBean.getCanonicalName() + ")");
        }
        if (request.hasSingleAttribute()) {
            return request.getAttributes();
        }
        JSONObject attributes = (JSONObject)this.getValue();
        return attributes.keySet();
    }

    public <V> V getValue(ObjectName pObjectName, String pAttribute) {
        ObjectName requestMBean = ((J4pReadRequest)this.getRequest()).getObjectName();
        if (requestMBean.isPattern()) {
            JSONObject mAttributes = this.getAttributesForObjectNameWithPatternRequest(pObjectName);
            if (!mAttributes.containsKey(pAttribute)) {
                throw new IllegalArgumentException("No attribute " + pAttribute + " for ObjectName " + pObjectName + " returned for" + " the given request");
            }
            return mAttributes.get(pAttribute);
        }
        return this.getValue(pAttribute);
    }

    public <V> V getValue(String pAttribute) {
        J4pReadRequest request = (J4pReadRequest)this.getRequest();
        ObjectName requestBean = request.getObjectName();
        if (requestBean.isPattern()) {
            throw new IllegalArgumentException("Attributes without ObjectName can be fetched only for non-pattern request (current: " + requestBean.getCanonicalName() + ")");
        }
        if (request.hasSingleAttribute()) {
            if (pAttribute != null && !pAttribute.equals(request.getAttribute())) {
                throw new IllegalArgumentException("Given attribute " + pAttribute + " doesnt match single attribute " + "given " + request.getAttribute() + " in the request");
            }
            return this.getValue();
        }
        JSONObject attributes = (JSONObject)this.getValue();
        if (pAttribute == null) {
            throw new IllegalArgumentException("Cannot use null-attribute name to fetch a value from a multi-attribute request");
        }
        if (!attributes.containsKey(pAttribute)) {
            throw new IllegalArgumentException("No such key " + pAttribute + " in the set of returned attribute values");
        }
        return attributes.get(pAttribute);
    }

    private JSONObject getAttributesForObjectNameWithPatternRequest(ObjectName pObjectName) {
        ObjectName pMBeanFromRequest = ((J4pReadRequest)this.getRequest()).getObjectName();
        ObjectName objectName = pObjectName == null ? pMBeanFromRequest : pObjectName;
        JSONObject values = (JSONObject)this.getValue();
        JSONObject attributes = (JSONObject)values.get(objectName.getCanonicalName());
        if (attributes == null) {
            throw new IllegalArgumentException("No ObjectName " + objectName + " found in the set of returned " + " ObjectNames for requested pattern " + pMBeanFromRequest);
        }
        return attributes;
    }
}

