/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.core.launcher;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.shaded.wildfly.core.launcher.AbstractCommandBuilder;
import org.shaded.wildfly.core.launcher.Arguments;
import org.shaded.wildfly.core.launcher.CommandBuilder;
import org.shaded.wildfly.core.launcher.Environment;

public class DomainCommandBuilder
extends AbstractCommandBuilder<DomainCommandBuilder>
implements CommandBuilder {
    private static final String DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    private static final String DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    private static final String DOMAIN_LOG_DIR = "jboss.domain.log.dir";
    private Path hostControllerJavaHome;
    private Path serverJavaHome;
    private Path baseDir;
    private final Arguments hostControllerJavaOpts = new Arguments();
    private final Arguments processControllerJavaOpts;

    private DomainCommandBuilder(Path wildflyHome, Path javaHome) {
        super(wildflyHome, javaHome);
        this.hostControllerJavaOpts.addAll(DEFAULT_VM_ARGUMENTS);
        this.processControllerJavaOpts = new Arguments();
        this.processControllerJavaOpts.addAll(DEFAULT_VM_ARGUMENTS);
    }

    public static DomainCommandBuilder of(Path wildflyHome) {
        return new DomainCommandBuilder(DomainCommandBuilder.validateWildFlyDir(wildflyHome), Environment.getDefaultJavaHome());
    }

    public static DomainCommandBuilder of(String wildflyHome) {
        return new DomainCommandBuilder(DomainCommandBuilder.validateWildFlyDir(wildflyHome), Environment.getDefaultJavaHome());
    }

    public static DomainCommandBuilder of(String wildflyHome, String javaHome) {
        return new DomainCommandBuilder(DomainCommandBuilder.validateWildFlyDir(wildflyHome), DomainCommandBuilder.validateJavaHome(javaHome));
    }

    public static DomainCommandBuilder of(Path wildflyHome, Path javaHome) {
        return new DomainCommandBuilder(DomainCommandBuilder.validateWildFlyDir(wildflyHome), DomainCommandBuilder.validateJavaHome(javaHome));
    }

    public DomainCommandBuilder setBackup() {
        this.addServerArgument("--backup");
        return this;
    }

    public DomainCommandBuilder setCachedDomainController() {
        this.addServerArgument("--cached-dc");
        return this;
    }

    public DomainCommandBuilder setInterProcessHostControllerAddress(String address) {
        if (address != null) {
            this.setSingleServerArg("--interprocess-hc-address", address);
        }
        return this;
    }

    public DomainCommandBuilder setInterProcessHostControllerPort(String port) {
        if (port != null) {
            this.setInterProcessHostControllerPort(Integer.parseInt(port));
        }
        return this;
    }

    public DomainCommandBuilder setInterProcessHostControllerPort(int port) {
        if (port > -1) {
            this.setSingleServerArg("--interprocess-hc-port", Integer.toString(port));
        }
        return this;
    }

    public DomainCommandBuilder setMasterAddressHint(String address) {
        if (address != null) {
            this.setSingleServerArg("--master-address", address);
        }
        return this;
    }

    public DomainCommandBuilder setMasterPortHint(String port) {
        if (port != null) {
            this.setMasterPortHint(Integer.parseInt(port));
        }
        return this;
    }

    public DomainCommandBuilder setMasterPortHint(int port) {
        if (port > -1) {
            this.setSingleServerArg("--master-port", Integer.toString(port));
        }
        return this;
    }

    public DomainCommandBuilder setProcessControllerAddress(String address) {
        if (address != null) {
            this.setSingleServerArg("--pc-address", address);
        }
        return this;
    }

    public DomainCommandBuilder setProcessControllerPort(String port) {
        if (port != null) {
            this.setProcessControllerPort(Integer.parseInt(port));
        }
        return this;
    }

    public DomainCommandBuilder setProcessControllerPort(int port) {
        if (port > -1) {
            this.setSingleServerArg("--pc-port", Integer.toString(port));
        }
        return this;
    }

    public DomainCommandBuilder setBaseDirectory(String baseDir) {
        this.baseDir = DomainCommandBuilder.validateAndNormalizeDir(baseDir, true);
        return this;
    }

    public DomainCommandBuilder setBaseDirectory(Path baseDir) {
        this.baseDir = DomainCommandBuilder.validateAndNormalizeDir(baseDir, true);
        return this;
    }

    public DomainCommandBuilder setHostControllerJavaHome(String javaHome) {
        this.hostControllerJavaHome = javaHome == null ? null : DomainCommandBuilder.validateJavaHome(javaHome);
        return this;
    }

    public DomainCommandBuilder setHostControllerJavaHome(Path javaHome) {
        this.hostControllerJavaHome = javaHome == null ? null : DomainCommandBuilder.validateJavaHome(javaHome);
        return this;
    }

    public Path getHostControllerJavaHome() {
        if (this.hostControllerJavaHome == null) {
            return this.getJavaHome();
        }
        return this.hostControllerJavaHome;
    }

    public DomainCommandBuilder setHostConfiguration(String configFile) {
        if (configFile != null) {
            this.setSingleServerArg("--host-config", configFile);
        }
        return this;
    }

    public String getHostConfiguration() {
        return this.getServerArg("--host-config");
    }

    public DomainCommandBuilder setReadOnlyHostConfiguration(String configFile) {
        if (configFile != null) {
            this.setSingleServerArg("--read-only-host-config", configFile);
        }
        return this;
    }

    public String getReadOnlyHostConfiguration() {
        return this.getServerArg("--read-only-host-config");
    }

    public DomainCommandBuilder setDomainConfiguration(String configFile) {
        this.setSingleServerArg("-c", configFile);
        return this;
    }

    public String getDomainConfiguration() {
        return this.getServerArg("-c");
    }

    public DomainCommandBuilder setReadOnlyDomainConfiguration(String configFile) {
        if (configFile != null) {
            this.setSingleServerArg("--read-only-domain-config", configFile);
        }
        return this;
    }

    public String getReadOnlyDomainConfiguration() {
        return this.getServerArg("--read-only-domain-config");
    }

    public DomainCommandBuilder addHostControllerJavaOption(String arg) {
        if (arg != null && !arg.trim().isEmpty()) {
            Arguments.Argument argument = Arguments.parse(arg);
            switch (argument.getKey()) {
                case "jboss.domain.base.dir": {
                    if (argument.getValue() == null) break;
                    this.setBaseDirectory(argument.getValue());
                    break;
                }
                case "jboss.domain.config.dir": {
                    if (argument.getValue() == null) break;
                    this.setConfigurationDirectory(argument.getValue());
                    break;
                }
                case "jboss.domain.log.dir": {
                    if (argument.getValue() == null) break;
                    this.setLogDirectory(argument.getValue());
                    break;
                }
                default: {
                    this.hostControllerJavaOpts.add(argument);
                }
            }
        }
        return this;
    }

    public DomainCommandBuilder addHostControllerJavaOptions(String ... args) {
        if (args != null) {
            for (String arg : args) {
                this.addHostControllerJavaOption(arg);
            }
        }
        return this;
    }

    public DomainCommandBuilder addHostControllerJavaOptions(Iterable<String> args) {
        if (args != null) {
            for (String arg : args) {
                this.addHostControllerJavaOption(arg);
            }
        }
        return this;
    }

    public DomainCommandBuilder setHostControllerJavaOptions(String ... args) {
        this.hostControllerJavaOpts.clear();
        return this.addHostControllerJavaOptions(args);
    }

    public DomainCommandBuilder setHostControllerJavaOptions(Iterable<String> args) {
        this.hostControllerJavaOpts.clear();
        return this.addHostControllerJavaOptions(args);
    }

    public List<String> getHostControllerJavaOptions() {
        return this.hostControllerJavaOpts.asList();
    }

    public DomainCommandBuilder addProcessControllerJavaOption(String arg) {
        if (arg != null && !arg.trim().isEmpty()) {
            Arguments.Argument argument = Arguments.parse(arg);
            if (argument.getKey().equals("java.security.manager")) {
                this.setUseSecurityManager(true);
            } else {
                this.processControllerJavaOpts.add(argument);
            }
        }
        return this;
    }

    public DomainCommandBuilder addProcessControllerJavaOptions(String ... args) {
        if (args != null) {
            for (String arg : args) {
                this.addProcessControllerJavaOption(arg);
            }
        }
        return this;
    }

    public DomainCommandBuilder addProcessControllerJavaOptions(Iterable<String> args) {
        if (args != null) {
            for (String arg : args) {
                this.addProcessControllerJavaOption(arg);
            }
        }
        return this;
    }

    public DomainCommandBuilder setProcessControllerJavaOptions(String ... args) {
        this.processControllerJavaOpts.clear();
        return this.addProcessControllerJavaOptions(args);
    }

    public DomainCommandBuilder setProcessControllerJavaOptions(Iterable<String> args) {
        this.processControllerJavaOpts.clear();
        return this.addProcessControllerJavaOptions(args);
    }

    public List<String> getProcessControllerJavaOptions() {
        return this.processControllerJavaOpts.asList();
    }

    public DomainCommandBuilder setServerJavaHome(String javaHome) {
        this.serverJavaHome = javaHome == null ? null : DomainCommandBuilder.validateJavaHome(javaHome);
        return this;
    }

    public DomainCommandBuilder setServerJavaHome(Path javaHome) {
        this.serverJavaHome = javaHome == null ? null : DomainCommandBuilder.validateJavaHome(javaHome);
        return this;
    }

    public Path getServerJavaHome() {
        if (this.serverJavaHome == null) {
            return this.getJavaHome();
        }
        return this.serverJavaHome;
    }

    @Override
    public List<String> buildArguments() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("-D[Process Controller]");
        DomainCommandBuilder.addSystemPropertyArg(cmd, "jboss.home.dir", this.getWildFlyHome());
        cmd.addAll(this.processControllerJavaOpts.asList());
        cmd.add(this.getBootLogArgument("process-controller.log"));
        cmd.add(this.getLoggingPropertiesArgument("logging.properties"));
        cmd.add("-jar");
        cmd.add(this.getModulesJarName());
        if (this.useSecurityManager()) {
            cmd.add("-secmgr");
        }
        cmd.add("-mp");
        cmd.add(this.getModulePaths());
        cmd.add("org.shaded.jboss.as.process-controller");
        cmd.add("-jboss-home");
        cmd.add(this.getWildFlyHome().toString());
        cmd.add("-jvm");
        cmd.add(this.getHostControllerJavaCommand());
        cmd.add("-mp");
        cmd.add(this.getModulePaths());
        cmd.add("--");
        cmd.add(this.getBootLogArgument("host-controller.log"));
        cmd.add(this.getLoggingPropertiesArgument("logging.properties"));
        cmd.addAll(this.hostControllerJavaOpts.asList());
        cmd.add("--");
        cmd.add("-default-jvm");
        cmd.add(this.getServerJavaCommand());
        DomainCommandBuilder.addSystemPropertyArg(cmd, DOMAIN_BASE_DIR, this.getBaseDirectory());
        DomainCommandBuilder.addSystemPropertyArg(cmd, DOMAIN_LOG_DIR, this.getLogDirectory());
        DomainCommandBuilder.addSystemPropertyArg(cmd, DOMAIN_CONFIG_DIR, this.getConfigurationDirectory());
        cmd.addAll(this.getServerArguments());
        return cmd;
    }

    @Override
    public List<String> build() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getJavaCommand());
        cmd.addAll(this.buildArguments());
        return cmd;
    }

    @Override
    public Path getJavaHome() {
        return this.environment.getJavaHome();
    }

    @Override
    public Path getBaseDirectory() {
        if (this.baseDir == null) {
            return this.normalizePath("domain");
        }
        return this.baseDir;
    }

    @Override
    protected DomainCommandBuilder getThis() {
        return this;
    }

    private String getHostControllerJavaCommand() {
        if (this.hostControllerJavaHome != null) {
            return this.getJavaCommand(this.hostControllerJavaHome);
        }
        return this.getJavaCommand();
    }

    private String getServerJavaCommand() {
        if (this.serverJavaHome != null) {
            return this.getJavaCommand(this.serverJavaHome);
        }
        return this.getJavaCommand();
    }
}

