/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.core.launcher;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.shaded.wildfly.core.launcher.VersionComparator;
import org.shaded.wildfly.core.launcher.logger.LauncherMessages;

class Environment {
    private static final String JAVA_EXE;
    private static final Path JAVA_HOME;
    private static final boolean MAC;
    private static final boolean WINDOWS;
    private static final boolean JAVA_1_8_PLUS;
    static final String HOME_DIR = "jboss.home.dir";
    static final String MODULES_JAR_NAME = "jboss-modules.jar";
    private final Path wildflyHome;
    private Path javaHome;
    private final List<String> modulesDirs;
    private boolean addDefaultModuleDir;

    Environment(String wildflyHome) {
        this(Environment.validateWildFlyDir(wildflyHome));
    }

    Environment(Path wildflyHome) {
        this.wildflyHome = Environment.validateWildFlyDir(wildflyHome);
        this.modulesDirs = new ArrayList<String>();
        this.addDefaultModuleDir = true;
    }

    public Path getWildflyHome() {
        return this.wildflyHome;
    }

    public Path getModuleJar() {
        return this.resolvePath(MODULES_JAR_NAME);
    }

    public void addModuleDir(String moduleDir) {
        if (moduleDir == null) {
            throw LauncherMessages.MESSAGES.nullParam("moduleDir");
        }
        Path path = Paths.get(moduleDir, new String[0]).normalize();
        this.modulesDirs.add(path.toString());
    }

    public void addModuleDirs(String ... moduleDirs) {
        for (String path : moduleDirs) {
            this.addModuleDir(path);
        }
    }

    public void addModuleDirs(Iterable<String> moduleDirs) {
        for (String path : moduleDirs) {
            this.addModuleDir(path);
        }
    }

    public void setModuleDirs(Iterable<String> moduleDirs) {
        this.modulesDirs.clear();
        for (String path : moduleDirs) {
            this.addModuleDir(path);
        }
        this.addDefaultModuleDir = false;
    }

    public void setModuleDirs(String ... moduleDirs) {
        this.modulesDirs.clear();
        for (String path : moduleDirs) {
            this.addModuleDir(path);
        }
        this.addDefaultModuleDir = false;
    }

    public String getModulePaths() {
        StringBuilder result = new StringBuilder();
        if (this.addDefaultModuleDir) {
            result.append(this.wildflyHome.resolve("modules").toString());
        }
        if (!this.modulesDirs.isEmpty()) {
            if (this.addDefaultModuleDir) {
                result.append(File.pathSeparator);
            }
            Iterator<String> iterator = this.modulesDirs.iterator();
            while (iterator.hasNext()) {
                result.append(iterator.next());
                if (!iterator.hasNext()) continue;
                result.append(File.pathSeparator);
            }
        }
        return result.toString();
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome == null ? null : Environment.validateJavaHome(javaHome);
    }

    public void setJavaHome(Path javaHome) {
        this.javaHome = javaHome == null ? null : Environment.validateJavaHome(javaHome);
    }

    public Path getJavaHome() {
        Path path = this.javaHome == null ? JAVA_HOME : this.javaHome;
        return path;
    }

    public String getJavaCommand() {
        return this.getJavaCommand(this.javaHome);
    }

    public String getJavaCommand(Path javaHome) {
        Path dir = javaHome == null ? this.getJavaHome() : javaHome;
        String exe = dir == null ? "java" : dir.resolve("bin").resolve("java").toString();
        if (exe.contains(" ")) {
            return "\"" + exe + "\"";
        }
        return exe;
    }

    public Path resolvePath(String ... paths) {
        Path result = this.wildflyHome;
        for (String path : paths) {
            result = result.resolve(path);
        }
        return result;
    }

    public static boolean isMac() {
        return MAC;
    }

    public static boolean isWindows() {
        return WINDOWS;
    }

    public static boolean supportsMaxPermSize() {
        return JAVA_1_8_PLUS;
    }

    static Path getDefaultJavaHome() {
        return JAVA_HOME;
    }

    static Path validateWildFlyDir(String wildflyHome) {
        if (wildflyHome == null) {
            throw LauncherMessages.MESSAGES.pathDoesNotExist(null);
        }
        return Environment.validateWildFlyDir(Paths.get(wildflyHome, new String[0]));
    }

    static Path validateWildFlyDir(Path wildflyHome) {
        if (wildflyHome == null || Files.notExists(wildflyHome, new LinkOption[0])) {
            throw LauncherMessages.MESSAGES.pathDoesNotExist(wildflyHome);
        }
        if (!Files.isDirectory(wildflyHome, new LinkOption[0])) {
            throw LauncherMessages.MESSAGES.invalidDirectory(wildflyHome);
        }
        Path result = wildflyHome.toAbsolutePath().normalize();
        if (Files.notExists(result.resolve(MODULES_JAR_NAME), new LinkOption[0])) {
            throw LauncherMessages.MESSAGES.invalidDirectory(MODULES_JAR_NAME, wildflyHome);
        }
        return result;
    }

    static Path validateJavaHome(String javaHome) {
        if (javaHome == null) {
            throw LauncherMessages.MESSAGES.pathDoesNotExist(null);
        }
        return Environment.validateJavaHome(Paths.get(javaHome, new String[0]));
    }

    static Path validateJavaHome(Path javaHome) {
        if (javaHome == null || Files.notExists(javaHome, new LinkOption[0])) {
            throw LauncherMessages.MESSAGES.pathDoesNotExist(javaHome);
        }
        if (!Files.isDirectory(javaHome, new LinkOption[0])) {
            throw LauncherMessages.MESSAGES.invalidDirectory(javaHome);
        }
        Path result = javaHome.toAbsolutePath().normalize();
        Path exe = result.resolve("bin").resolve(JAVA_EXE);
        if (Files.notExists(exe, new LinkOption[0])) {
            int count = exe.getNameCount();
            throw LauncherMessages.MESSAGES.invalidDirectory(exe.subpath(count - 2, count).toString(), javaHome);
        }
        return result;
    }

    static {
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        MAC = os.startsWith("mac");
        WINDOWS = os.contains("win");
        String exe = "java";
        if (WINDOWS) {
            exe = "java.exe";
        }
        JAVA_EXE = exe;
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null) {
            javaHome = System.getProperty("java.home");
        }
        JAVA_HOME = Paths.get(javaHome, new String[0]);
        String jvmVersion = System.getProperty("java.specification.version");
        JAVA_1_8_PLUS = VersionComparator.compareVersion(jvmVersion, "1.8") < 0;
    }
}

