/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.core.launcher;

public class ProcessHelper {
    public static boolean processHasDied(Process process) {
        try {
            process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return false;
        }
    }

    public static int destroyProcess(Process process) throws InterruptedException {
        if (process == null) {
            return 0;
        }
        process.destroy();
        return process.waitFor();
    }

    public static Thread addShutdownHook(final Process process) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (process != null) {
                    process.destroy();
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        thread.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(thread);
        return thread;
    }
}

