/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.core.launcher.logger;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;

class Messages {
    private Messages() {
    }

    public static <T> T getBundle(final Class<T> type) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                Field field;
                Locale locale = Locale.getDefault();
                String lang = locale.getLanguage();
                String country = locale.getCountry();
                String variant = locale.getVariant();
                Class bundleClass = null;
                if (variant != null && !variant.isEmpty()) {
                    try {
                        bundleClass = Class.forName(Messages.join(type.getName(), "$bundle", lang, country, variant), true, type.getClassLoader()).asSubclass(type);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                if (bundleClass == null && country != null && !country.isEmpty()) {
                    try {
                        bundleClass = Class.forName(Messages.join(type.getName(), "$bundle", lang, country, null), true, type.getClassLoader()).asSubclass(type);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                if (bundleClass == null && lang != null && !lang.isEmpty()) {
                    try {
                        bundleClass = Class.forName(Messages.join(type.getName(), "$bundle", lang, null, null), true, type.getClassLoader()).asSubclass(type);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                if (bundleClass == null) {
                    try {
                        bundleClass = Class.forName(Messages.join(type.getName(), "$bundle", null, null, null), true, type.getClassLoader()).asSubclass(type);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Invalid bundle " + type + " (implementation not found)");
                    }
                }
                try {
                    field = bundleClass.getField("INSTANCE");
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalArgumentException("Bundle implementation " + bundleClass + " has no instance field");
                }
                try {
                    return type.cast(field.get(null));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Bundle implementation " + bundleClass + " could not be instantiated", e);
                }
            }
        });
    }

    private static String join(String interfaceName, String type, String lang, String country, String variant) {
        StringBuilder build = new StringBuilder();
        build.append(interfaceName).append('_').append(type);
        if (lang != null && !lang.isEmpty()) {
            build.append('_');
            build.append(lang);
        }
        if (country != null && !country.isEmpty()) {
            build.append('_');
            build.append(country);
        }
        if (variant != null && !variant.isEmpty()) {
            build.append('_');
            build.append(variant);
        }
        return build.toString();
    }
}

