/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.plugin.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.shaded.jboss.as.controller.client.Operation;
import org.shaded.jboss.as.controller.client.helpers.Operations;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.wildfly.plugin.core.Assertions;
import org.shaded.wildfly.plugin.core.Deployment;
import org.shaded.wildfly.plugin.core.DeploymentDescription;
import org.shaded.wildfly.plugin.core.UndeployDescription;

public class DeploymentOperations {
    static final String ENABLED = "enabled";
    static final ModelNode EMPTY_ADDRESS = new ModelNode().setEmptyList();

    static ModelNode createAddress(String ... pairs) {
        return DeploymentOperations.createAddress(Arrays.asList(pairs));
    }

    static ModelNode createAddress(Iterable<String> pairs) {
        ModelNode address = new ModelNode();
        Iterator<String> iterator = pairs.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            String value = iterator.hasNext() ? iterator.next() : "*";
            address.add(key, value);
        }
        return address;
    }

    public static Operation createAddDeploymentOperation(Deployment deployment) {
        Assertions.requiresNotNullParameter(deployment, "deployment");
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create(true);
        DeploymentOperations.addDeploymentOperationStep(builder, deployment);
        return builder.build();
    }

    public static Operation createAddDeploymentOperation(Set<Deployment> deployments) {
        Assertions.requiresNotNullOrNotEmptyParameter(deployments, "deployments");
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create(true);
        for (Deployment deployment : deployments) {
            DeploymentOperations.addDeploymentOperationStep(builder, deployment);
        }
        return builder.build();
    }

    public static Operation createDeployOperation(DeploymentDescription deployment) {
        Assertions.requiresNotNullParameter(deployment, "deployment");
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create(true);
        DeploymentOperations.addDeployOperationStep(builder, deployment);
        return builder.build();
    }

    public static Operation createDeployOperation(Set<DeploymentDescription> deployments) {
        Assertions.requiresNotNullOrNotEmptyParameter(deployments, "deployments");
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create(true);
        for (DeploymentDescription deployment : deployments) {
            DeploymentOperations.addDeployOperationStep(builder, deployment);
        }
        return builder.build();
    }

    public static Operation createReplaceOperation(Deployment deployment) {
        Assertions.requiresNotNullParameter(deployment, "deployment");
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create(true);
        DeploymentOperations.addReplaceOperationSteps(builder, deployment);
        return builder.build();
    }

    public static Operation createReplaceOperation(Set<Deployment> deployments) {
        Assertions.requiresNotNullOrNotEmptyParameter(deployments, "deployments");
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create(true);
        for (Deployment deployment : deployments) {
            DeploymentOperations.addReplaceOperationSteps(builder, deployment);
        }
        return builder.build();
    }

    public static Operation createRedeployOperation(DeploymentDescription deployment) {
        Assertions.requiresNotNullParameter(deployment, "deployment");
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create(true);
        DeploymentOperations.addRedeployOperationStep(builder, deployment);
        return builder.build();
    }

    public static Operation createRedeployOperation(Set<DeploymentDescription> deployments) {
        Assertions.requiresNotNullOrNotEmptyParameter(deployments, "deployments");
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create(true);
        for (DeploymentDescription deployment : deployments) {
            DeploymentOperations.addRedeployOperationStep(builder, deployment);
        }
        return builder.build();
    }

    public static Operation createUndeployOperation(UndeployDescription undeployDescription) {
        Assertions.requiresNotNullParameter(undeployDescription, "undeployDescription");
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create(true);
        DeploymentOperations.addUndeployOperationStep(builder, undeployDescription);
        return builder.build();
    }

    public static Operation createUndeployOperation(Set<UndeployDescription> undeployDescriptions) {
        Assertions.requiresNotNullOrNotEmptyParameter(undeployDescriptions, "undeployDescriptions");
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create(true);
        for (UndeployDescription undeployDescription : undeployDescriptions) {
            DeploymentOperations.addUndeployOperationStep(builder, undeployDescription);
        }
        return builder.build();
    }

    static void addDeploymentOperationStep(Operations.CompositeOperationBuilder builder, Deployment deployment) {
        String name = deployment.getName();
        ModelNode address = DeploymentOperations.createAddress("deployment", name);
        String runtimeName = deployment.getRuntimeName();
        ModelNode addOperation = Operations.createAddOperation(address);
        if (runtimeName != null) {
            addOperation.get("runtime-name").set(runtimeName);
        }
        addOperation.get(ENABLED).set(deployment.isEnabled());
        DeploymentOperations.addContent(builder, addOperation, deployment);
        builder.addStep(addOperation);
        Set<String> serverGroups = deployment.getServerGroups();
        if (!serverGroups.isEmpty()) {
            for (String serverGroup : serverGroups) {
                ModelNode sgAddress = DeploymentOperations.createAddress("server-group", serverGroup, "deployment", name);
                ModelNode op = Operations.createAddOperation(sgAddress);
                op.get(ENABLED).set(deployment.isEnabled());
                if (runtimeName != null) {
                    op.get("runtime-name").set(runtimeName);
                }
                builder.addStep(op);
            }
        }
    }

    static void addDeployOperationStep(Operations.CompositeOperationBuilder builder, DeploymentDescription deployment) {
        String name = deployment.getName();
        Set<String> serverGroups = deployment.getServerGroups();
        if (serverGroups.isEmpty()) {
            ModelNode address = DeploymentOperations.createAddress("deployment", name);
            builder.addStep(Operations.createOperation("deploy", address));
        } else {
            for (String serverGroup : serverGroups) {
                ModelNode address = DeploymentOperations.createAddress("server-group", serverGroup, "deployment", name);
                builder.addStep(Operations.createOperation("deploy", address));
            }
        }
    }

    static void addReplaceOperationSteps(Operations.CompositeOperationBuilder builder, Deployment deployment, DeploymentDescription currentDeployment, boolean allowAddIfMissing) {
        LinkedHashSet<String> serverGroups;
        String name = deployment.getName();
        String runtimeName = deployment.getRuntimeName();
        if (allowAddIfMissing && !(serverGroups = new LinkedHashSet<String>(deployment.getServerGroups())).isEmpty()) {
            serverGroups.removeAll(currentDeployment.getServerGroups());
            for (String serverGroup : serverGroups) {
                ModelNode sgAddress = DeploymentOperations.createAddress("server-group", serverGroup, "deployment", name);
                ModelNode addOp = Operations.createAddOperation(sgAddress);
                addOp.get(ENABLED).set(false);
                if (runtimeName != null) {
                    addOp.get("runtime-name").set(runtimeName);
                }
                builder.addStep(addOp);
            }
        }
        ModelNode op = Operations.createOperation("full-replace-deployment");
        op.get("name").set(name);
        if (runtimeName != null) {
            op.get("runtime-name").set(runtimeName);
        }
        DeploymentOperations.addContent(builder, op, deployment);
        op.get(ENABLED).set(deployment.isEnabled());
        builder.addStep(op);
    }

    static void addReplaceOperationSteps(Operations.CompositeOperationBuilder builder, Deployment deployment) {
        String name = deployment.getName();
        String runtimeName = deployment.getRuntimeName();
        ModelNode op = Operations.createOperation("full-replace-deployment");
        op.get("name").set(name);
        if (runtimeName != null) {
            op.get("runtime-name").set(runtimeName);
        }
        DeploymentOperations.addContent(builder, op, deployment);
        op.get(ENABLED).set(deployment.isEnabled());
        builder.addStep(op);
    }

    private static void addRedeployOperationStep(Operations.CompositeOperationBuilder builder, DeploymentDescription deployment) {
        String deploymentName = deployment.getName();
        Set<String> serverGroups = deployment.getServerGroups();
        if (serverGroups.isEmpty()) {
            builder.addStep(Operations.createOperation("redeploy", DeploymentOperations.createAddress("deployment", deploymentName)));
        } else {
            for (String serverGroup : serverGroups) {
                builder.addStep(Operations.createOperation("redeploy", DeploymentOperations.createAddress("server-group", serverGroup, "deployment", deploymentName)));
            }
        }
    }

    private static void addUndeployOperationStep(Operations.CompositeOperationBuilder builder, UndeployDescription undeployDescription) {
        String name = undeployDescription.getName();
        Set<String> serverGroups = undeployDescription.getServerGroups();
        if (serverGroups.isEmpty()) {
            ModelNode address = DeploymentOperations.createAddress("deployment", name);
            builder.addStep(Operations.createOperation("undeploy", address));
            if (undeployDescription.isRemoveContent()) {
                builder.addStep(Operations.createRemoveOperation(address));
            }
        } else {
            for (String serverGroup : serverGroups) {
                ModelNode address = DeploymentOperations.createAddress("server-group", serverGroup, "deployment", name);
                builder.addStep(Operations.createOperation("undeploy", address));
                if (!undeployDescription.isRemoveContent()) continue;
                builder.addStep(Operations.createRemoveOperation(address));
            }
            if (undeployDescription.isRemoveContent()) {
                builder.addStep(Operations.createRemoveOperation(DeploymentOperations.createAddress("deployment", name)));
            }
        }
    }

    private static void addContent(Operations.CompositeOperationBuilder builder, ModelNode op, Deployment deployment) {
        deployment.getContent().addContentToOperation(builder, op);
    }

    static {
        EMPTY_ADDRESS.protect();
    }
}

