/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.security.ssl;

import java.util.EnumSet;
import org.shaded.wildfly.security._private.ElytronMessages;

public enum Authentication {
    NULL,
    RSA,
    DSS,
    DH,
    ECDH,
    KRB5,
    ECDSA,
    PSK,
    GOST94,
    GOST01,
    FZA;

    static final int fullSize;

    static Authentication forName(String name) {
        switch (name) {
            case "NULL": {
                return NULL;
            }
            case "RSA": {
                return RSA;
            }
            case "DSS": {
                return DSS;
            }
            case "DH": {
                return DH;
            }
            case "ECDH": {
                return ECDH;
            }
            case "KRB5": {
                return KRB5;
            }
            case "ECDSA": {
                return ECDSA;
            }
            case "PSK": {
                return PSK;
            }
            case "GOST94": {
                return GOST94;
            }
            case "GOST01": {
                return GOST01;
            }
            case "FZA": {
                return FZA;
            }
        }
        return null;
    }

    static Authentication require(String name) {
        Authentication authentication = Authentication.forName(name);
        if (authentication == null) {
            throw ElytronMessages.log.unknownAuthenticationName(name);
        }
        return authentication;
    }

    public static boolean isFull(EnumSet<Authentication> authentications) {
        return authentications != null && authentications.size() == fullSize;
    }

    public boolean in(Authentication value1, Authentication value2) {
        return this == value1 || this == value2;
    }

    public boolean in(Authentication value1, Authentication value2, Authentication value3) {
        return this == value1 || this == value2 || this == value3;
    }

    public boolean in(Authentication ... values) {
        if (values != null) {
            for (Authentication value : values) {
                if (this != value) continue;
                return true;
            }
        }
        return false;
    }

    static {
        fullSize = Authentication.values().length;
    }
}

