/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.security.ssl;

import java.util.EnumSet;
import org.shaded.wildfly.security.ssl.Authentication;
import org.shaded.wildfly.security.ssl.CipherSuitePredicate;
import org.shaded.wildfly.security.ssl.MechanismDatabase;

final class AuthenticationCipherSuitePredicate
extends CipherSuitePredicate {
    private final boolean accept;
    private final EnumSet<Authentication> set;

    AuthenticationCipherSuitePredicate(boolean accept, EnumSet<Authentication> set) {
        this.accept = accept;
        this.set = set;
    }

    @Override
    boolean test(MechanismDatabase.Entry entry) {
        return this.set.contains((Object)entry.getAuthentication()) == this.accept;
    }

    @Override
    boolean isAlwaysTrue() {
        return this.set.size() == Authentication.fullSize;
    }

    @Override
    boolean isAlwaysFalse() {
        return this.set.isEmpty();
    }
}

