/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.security.ssl;

import java.util.EnumSet;
import org.shaded.wildfly.security.ssl.CipherSuitePredicate;
import org.shaded.wildfly.security.ssl.KeyAgreement;
import org.shaded.wildfly.security.ssl.MechanismDatabase;

final class KeyAgreementCipherSuitePredicate
extends CipherSuitePredicate {
    private final EnumSet<KeyAgreement> set;

    KeyAgreementCipherSuitePredicate(EnumSet<KeyAgreement> set) {
        this.set = set;
    }

    @Override
    public boolean test(MechanismDatabase.Entry entry) {
        return this.set.contains((Object)entry.getKeyAgreement());
    }

    @Override
    boolean isAlwaysTrue() {
        return this.set.size() == KeyAgreement.fullSize;
    }

    @Override
    boolean isAlwaysFalse() {
        return this.set.isEmpty();
    }
}

