/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import javax.shaded.json.Json;
import javax.shaded.json.JsonBuilderFactory;
import javax.shaded.json.JsonObject;
import oshi.hardware.GlobalMemory;
import oshi.json.NullAwareJsonObjectBuilder;

public abstract class AbstractGlobalMemory
implements GlobalMemory {
    private static final long serialVersionUID = 1L;
    protected long memTotal = 0L;
    protected long memAvailable = 0L;
    protected long swapTotal = 0L;
    protected long swapUsed = 0L;
    private JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);

    protected abstract void updateMeminfo();

    protected abstract void updateSwap();

    @Override
    public long getAvailable() {
        this.updateMeminfo();
        return this.memAvailable;
    }

    @Override
    public long getTotal() {
        if (this.memTotal == 0L) {
            this.updateMeminfo();
        }
        return this.memTotal;
    }

    @Override
    public long getSwapUsed() {
        this.updateSwap();
        return this.swapUsed;
    }

    @Override
    public long getSwapTotal() {
        this.updateSwap();
        return this.swapTotal;
    }

    @Override
    public JsonObject toJSON() {
        return NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder()).add("available", this.getAvailable()).add("total", this.getTotal()).add("swapTotal", this.getSwapTotal()).add("swapUsed", this.getSwapUsed()).build();
    }
}

