/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.ArrayList;
import org.shaded.slf4j.Logger;
import org.shaded.slf4j.LoggerFactory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.common.AbstractDisks;
import oshi.hardware.platform.linux.LinuxBlockDevStats;
import oshi.jna.platform.linux.Udev;
import oshi.util.ParseUtil;

public class LinuxDisks
extends AbstractDisks {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LinuxDisks.class);
    private final int SECTORSIZE = 512;

    private void computeDiskStats(HWDiskStore store, Udev.UdevDevice disk) {
        LinuxBlockDevStats stats = new LinuxBlockDevStats(store.getName(), disk);
        long l = stats.read_512bytes;
        this.getClass();
        store.setReads(l * 512L);
        long l2 = stats.write_512bytes;
        this.getClass();
        store.setWrites(l2 * 512L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public HWDiskStore[] getDisks() {
        Udev.UdevHandle handle = null;
        Udev.UdevDevice device = null;
        Udev.UdevEnumerate enumerate = null;
        ArrayList<HWDiskStore> result = new ArrayList<HWDiskStore>();
        handle = Udev.INSTANCE.udev_new();
        enumerate = Udev.INSTANCE.udev_enumerate_new(handle);
        Udev.INSTANCE.udev_enumerate_add_match_subsystem(enumerate, "block");
        Udev.INSTANCE.udev_enumerate_scan_devices(enumerate);
        Udev.UdevListEntry entry = Udev.INSTANCE.udev_enumerate_get_list_entry(enumerate);
        while (true) {
            HWDiskStore store = new HWDiskStore();
            Udev.UdevListEntry oldEntry = entry;
            device = Udev.INSTANCE.udev_device_new_from_syspath(handle, Udev.INSTANCE.udev_list_entry_get_name(entry));
            if (Udev.INSTANCE.udev_device_get_devtype(device).equals("disk") && !Udev.INSTANCE.udev_device_get_devnode(device).startsWith("/dev/loop") && !Udev.INSTANCE.udev_device_get_devnode(device).startsWith("/dev/ram")) {
                store.setName(Udev.INSTANCE.udev_device_get_devnode(device));
                store.setModel(Udev.INSTANCE.udev_device_get_property_value(device, "ID_MODEL") == null ? "Unknown" : Udev.INSTANCE.udev_device_get_property_value(device, "ID_MODEL"));
                store.setSerial(Udev.INSTANCE.udev_device_get_property_value(device, "ID_SERIAL_SHORT") == null ? "Unknown" : Udev.INSTANCE.udev_device_get_property_value(device, "ID_SERIAL_SHORT"));
                store.setSize(ParseUtil.parseLongOrDefault(Udev.INSTANCE.udev_device_get_sysattr_value(device, "size"), 0L) * 512L);
                this.computeDiskStats(store, device);
                result.add(store);
            }
            entry = Udev.INSTANCE.udev_list_entry_get_next(oldEntry);
            if (!(device instanceof Udev.UdevDevice)) continue;
            Udev.INSTANCE.udev_device_unref(device);
        }
        catch (Exception ex) {
            try {
                LOG.debug("Reached all disks. Exiting ");
            }
            catch (Throwable throwable) {
                if (device instanceof Udev.UdevDevice) {
                    Udev.INSTANCE.udev_device_unref(device);
                }
                throw throwable;
            }
            if (device instanceof Udev.UdevDevice) {
                Udev.INSTANCE.udev_device_unref(device);
            }
        }
        Udev.INSTANCE.udev_enumerate_unref(enumerate);
        Udev.INSTANCE.udev_unref(handle);
        return result.toArray(new HWDiskStore[result.size()]);
    }
}

