/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.hardware.HWDiskStore;
import oshi.hardware.common.AbstractDisks;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsDisks
extends AbstractDisks {
    private static final long serialVersionUID = 1L;
    private static Map<String, Long> readMap = new HashMap<String, Long>();
    private static Map<String, Long> writeMap = new HashMap<String, Long>();
    private static final WmiUtil.ValueType[] DRIVE_TYPES = new WmiUtil.ValueType[]{WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.UINT32};

    @Override
    public HWDiskStore[] getDisks() {
        ArrayList<HWDiskStore> result = new ArrayList<HWDiskStore>();
        readMap.clear();
        writeMap.clear();
        this.populateReadWriteMaps();
        Map<String, List<Object>> vals = WmiUtil.selectObjectsFrom(null, "Win32_DiskDrive", "Name,Manufacturer,Model,SerialNumber,Size,Index", null, DRIVE_TYPES);
        for (int i = 0; i < vals.get("Name").size(); ++i) {
            HWDiskStore ds = new HWDiskStore();
            ds.setName((String)vals.get("Name").get(i));
            ds.setModel(String.format("%s %s", vals.get("Model").get(i), vals.get("Manufacturer").get(i)).trim());
            ds.setSerial(ParseUtil.hexStringToString((String)vals.get("SerialNumber").get(i)));
            String index = vals.get("Index").get(i).toString();
            ds.setReads(readMap.getOrDefault(index, 0L));
            ds.setWrites(writeMap.getOrDefault(index, 0L));
            ds.setSize(ParseUtil.parseLongOrDefault((String)vals.get("Size").get(i), 0L));
            result.add(ds);
        }
        return result.toArray(new HWDiskStore[result.size()]);
    }

    private void populateReadWriteMaps() {
        Map<String, List<String>> vals = WmiUtil.selectStringsFrom(null, "Win32_PerfRawData_PerfDisk_PhysicalDisk", "Name,DiskReadBytesPerSec,DiskWriteBytesPerSec", null);
        for (int i = 0; i < vals.get("Name").size(); ++i) {
            String index = vals.get("Name").get(i).split("\\s+")[0];
            readMap.put(index, ParseUtil.parseLongOrDefault(vals.get("DiskReadBytesPerSec").get(i), 0L));
            writeMap.put(index, ParseUtil.parseLongOrDefault(vals.get("DiskWriteBytesPerSec").get(i), 0L));
        }
    }
}

